/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.wechat.pay.contrib.apache.httpclient.auth.PublicKeyVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import java.security.PublicKey;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(MixVerifier.class);
    final PublicKeyVerifier publicKeyVerifier;
    final Verifier certificateVerifier;

    public MixVerifier(PublicKeyVerifier publicKeyVerifier, Verifier certificateVerifier) {
        if (publicKeyVerifier == null) {
            throw new IllegalArgumentException("publicKeyVerifier cannot be null");
        }
        this.publicKeyVerifier = publicKeyVerifier;
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        if (Objects.equals(this.publicKeyVerifier.getSerialNumber(), serialNumber)) {
            return this.publicKeyVerifier.verify(serialNumber, message, signature);
        }
        if (this.certificateVerifier != null) {
            return this.certificateVerifier.verify(serialNumber, message, signature);
        }
        log.error("\u627e\u4e0d\u5230\u8bc1\u4e66\u5e8f\u5217\u53f7\u5bf9\u5e94\u7684\u8bc1\u4e66\uff0c\u5e8f\u5217\u53f7\uff1a{}", (Object)serialNumber);
        return false;
    }

    @Override
    public PublicKey getValidPublicKey() {
        return this.publicKeyVerifier.getValidPublicKey();
    }

    @Override
    public String getSerialNumber() {
        return this.publicKeyVerifier.getSerialNumber();
    }
}

