/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.client.CloudPullTopic;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.client.TransactionChecker;
import com.aliyun.mns.client.TransactionQueue;
import com.aliyun.mns.client.Utils;
import com.aliyun.mns.client.impl.account.GetAccountAttributesAction;
import com.aliyun.mns.client.impl.account.SetAccountAttributesAction;
import com.aliyun.mns.client.impl.queue.CreateQueueAction;
import com.aliyun.mns.client.impl.queue.ListQueueAction;
import com.aliyun.mns.client.impl.topic.ListTopicAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.http.ServiceClientFactory;
import com.aliyun.mns.model.AccountAttributes;
import com.aliyun.mns.model.PagingListResult;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.TopicMeta;
import com.aliyun.mns.model.request.account.GetAccountAttributesRequest;
import com.aliyun.mns.model.request.account.SetAccountAttributesRequest;
import com.aliyun.mns.model.request.queue.CreateQueueRequest;
import com.aliyun.mns.model.request.queue.ListQueueRequest;
import com.aliyun.mns.model.request.topic.ListTopicRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMNSClient
implements MNSClient {
    private static Log log = LogFactory.getLog(DefaultMNSClient.class);
    private static String OPERATION_LOG_QUEUE_POSTFIX = "-operation-log-queue";
    private boolean isOpen = true;
    private URI endpoint;
    private ServiceClient serviceClient;
    private ServiceCredentials credentials = new ServiceCredentials();
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public DefaultMNSClient(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, null);
    }

    public DefaultMNSClient(String endpoint, String accessId, String accessKey, ClientConfiguration config) {
        this.setEndpoint(endpoint);
        this.credentials = new ServiceCredentials(accessId, accessKey);
        if (config == null) {
            config = new ClientConfiguration();
            config.setExceptContinue(false);
        }
        this.serviceClient = ServiceClientFactory.createServiceClient(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initiated MNSClientImpl,accessId=" + accessId + ",accessKey=" + accessKey + ", endpoint=" + endpoint));
        }
    }

    public int getServiceClientHashCode() {
        return this.serviceClient.hashCode();
    }

    protected DefaultMNSClient(ServiceCredentials credentials, ServiceClient serviceClient, String endpoint) {
        this.serviceClient = serviceClient;
        this.credentials = credentials;
        this.setEndpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DefaultMNSClient defaultMNSClient = this;
        synchronized (defaultMNSClient) {
            if (this.isOpen && this.serviceClient != null) {
                ServiceClientFactory.closeServiceClient(this.serviceClient);
            }
            this.isOpen = false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void SetAccountAttributes(AccountAttributes accountAttributes) throws ServiceException, ClientException {
        SetAccountAttributesAction action = new SetAccountAttributesAction(this.serviceClient, this.credentials, this.endpoint);
        SetAccountAttributesRequest request = new SetAccountAttributesRequest();
        request.setAccountAttributes(accountAttributes);
        action.executeWithCustomHeaders(request, this.customHeaders);
    }

    @Override
    public AccountAttributes GetAccountAttributes() throws ServiceException, ClientException {
        GetAccountAttributesAction action = new GetAccountAttributesAction(this.serviceClient, this.credentials, this.endpoint);
        GetAccountAttributesRequest request = new GetAccountAttributesRequest();
        return (AccountAttributes)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    @Override
    public CloudQueue getQueueRef(String queueName) {
        CloudQueue cloudQueue = new CloudQueue(queueName, this.serviceClient, this.credentials, this.endpoint);
        if (this.customHeaders.size() > 0) {
            cloudQueue.setCustomHeaders(this.customHeaders);
        }
        return cloudQueue;
    }

    private void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = Utils.getHttpURI(endpoint);
    }

    public void addHeader(String key, String value) {
        this.customHeaders.put(key, value);
    }

    public AsyncResult<String> createQueueAsync(QueueMeta queueMeta, AsyncCallback<String> callback) {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        CreateQueueRequest request = new CreateQueueRequest();
        request.setRequestPath("queues/" + queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        return action.executeWithCustomHeaders(request, callback, this.customHeaders);
    }

    @Override
    public CloudQueue createQueue(QueueMeta queueMeta) throws ClientException, ServiceException {
        CloudQueue queue = new CloudQueue(queueMeta.getQueueName(), this.serviceClient, this.credentials, this.endpoint);
        queue.create(queueMeta);
        return queue;
    }

    @Override
    public TransactionQueue getTransQueueRef(String queueName, TransactionChecker checker) {
        CloudQueue queue = new CloudQueue(queueName, this.serviceClient, this.credentials, this.endpoint);
        CloudQueue opLogQueue = new CloudQueue(queueName + OPERATION_LOG_QUEUE_POSTFIX, this.serviceClient, this.credentials, this.endpoint);
        return new TransactionQueue(queue, opLogQueue, checker, TransactionQueue.DEFAULT_LIFE_TIME_IN_SECONDS, TransactionQueue.DEFAULT_DELAY\uff3fTIME_IN_SECONDS);
    }

    @Override
    public TransactionQueue createTransQueue(QueueMeta queueMeta, TransactionChecker checker, long lifeTime, long delayTime) throws ClientException, ServiceException {
        if (delayTime <= 0L || lifeTime <= 0L) {
            throw new IllegalArgumentException("delayTime(" + delayTime + ") or lifetime(" + lifeTime + ") should be bigger than 0");
        }
        CloudQueue queue = new CloudQueue(queueMeta.getQueueName(), this.serviceClient, this.credentials, this.endpoint);
        queueMeta.setMessageRetentionPeriod(lifeTime);
        queueMeta.setDelaySeconds(delayTime);
        queue.create(queueMeta);
        QueueMeta opLogQueueMeta = new QueueMeta();
        opLogQueueMeta.setQueueName(queueMeta.getQueueName() + OPERATION_LOG_QUEUE_POSTFIX);
        opLogQueueMeta.setPollingWaitSeconds(queueMeta.getPollingWaitSeconds());
        CloudQueue opLogQueue = new CloudQueue(opLogQueueMeta.getQueueName(), this.serviceClient, this.credentials, this.endpoint);
        opLogQueue.create(opLogQueueMeta);
        TransactionQueue transQueue = new TransactionQueue(queue, opLogQueue, checker, lifeTime, delayTime);
        return transQueue;
    }

    @Override
    public TransactionQueue createTransQueue(QueueMeta queueMeta, TransactionChecker checker) throws ClientException, ServiceException {
        return this.createTransQueue(queueMeta, checker, TransactionQueue.DEFAULT_LIFE_TIME_IN_SECONDS, TransactionQueue.DEFAULT_DELAY\uff3fTIME_IN_SECONDS);
    }

    @Override
    public TransactionQueue createTransQueue(QueueMeta queueMeta) throws ClientException, ServiceException {
        return this.createTransQueue(queueMeta, null, TransactionQueue.DEFAULT_LIFE_TIME_IN_SECONDS, TransactionQueue.DEFAULT_DELAY\uff3fTIME_IN_SECONDS);
    }

    @Override
    public CloudPullTopic createPullTopic(TopicMeta topicMeta, Vector<String> queueNameList, boolean needCreateQueue, QueueMeta queueMetaTemplate) throws ClientException, ServiceException {
        if (queueNameList == null || queueNameList.size() <= 0) {
            throw new IllegalArgumentException("queueNameList should not be null or empty.");
        }
        Vector<CloudQueue> queueList = new Vector<CloudQueue>();
        if (needCreateQueue) {
            QueueMeta queueMeta = null;
            if (queueMetaTemplate != null) {
                queueMeta = queueMetaTemplate;
            } else {
                queueMeta = new QueueMeta();
                queueMeta.setPollingWaitSeconds(30);
            }
            for (int i = 0; i < queueNameList.size(); ++i) {
                String queueName = queueNameList.get(i);
                queueMeta.setQueueName(queueName);
                CloudQueue queue = new CloudQueue(queueName, this.serviceClient, this.credentials, this.endpoint);
                queue.create(queueMeta);
                queueList.add(queue);
            }
        } else {
            for (int i = 0; i < queueNameList.size(); ++i) {
                String queueName = queueNameList.get(i);
                CloudQueue queue = new CloudQueue(queueName, this.serviceClient, this.credentials, this.endpoint);
                queueList.add(queue);
            }
        }
        CloudTopic rawTopic = this.createTopic(topicMeta);
        return new CloudPullTopic(rawTopic, queueNameList, queueList);
    }

    @Override
    public CloudPullTopic createPullTopic(TopicMeta topicMeta, Vector<String> queueNameList) throws ClientException, ServiceException {
        return this.createPullTopic(topicMeta, queueNameList, false, null);
    }

    @Override
    public PagingListResult<String> listQueueURL(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        PagingListResult<String> results = new PagingListResult<String>();
        PagingListResult<QueueMeta> list = this.listQueue(prefix, marker, retNumber, false);
        if (list != null && list.getResult() != null) {
            ArrayList<String> queues = new ArrayList<String>();
            for (QueueMeta meta : list.getResult()) {
                queues.add(meta.getQueueURL());
            }
            if (list.getMarker() != null) {
                results.setMarker(list.getMarker());
            }
            results.setResult(queues);
            return results;
        }
        return results;
    }

    @Override
    public PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        return this.listQueue(prefix, marker, retNumber, true);
    }

    private PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber, boolean withMeta) throws ClientException, ServiceException {
        ListQueueAction action = new ListQueueAction(this.serviceClient, this.credentials, this.endpoint);
        ListQueueRequest request = new ListQueueRequest();
        request.setRequestPath("/queues");
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        request.setWithMeta(withMeta);
        return (PagingListResult)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    @Override
    public CloudTopic getTopicRef(String topicName) {
        CloudTopic cloudTopic = new CloudTopic(topicName, this.serviceClient, this.credentials, this.endpoint);
        if (this.customHeaders.size() > 0) {
            cloudTopic.setCustomHeaders(this.customHeaders);
        }
        return cloudTopic;
    }

    @Override
    public CloudTopic createTopic(TopicMeta meta) {
        CloudTopic topic = new CloudTopic(meta.getTopicName(), this.serviceClient, this.credentials, this.endpoint);
        topic.create(meta);
        return topic;
    }

    @Override
    public PagingListResult<TopicMeta> listTopic(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        return this.listTopic(prefix, marker, retNumber, true);
    }

    private PagingListResult<TopicMeta> listTopic(String prefix, String marker, Integer retNumber, boolean withMeta) throws ClientException, ServiceException {
        ListTopicAction action = new ListTopicAction(this.serviceClient, this.credentials, this.endpoint);
        ListTopicRequest request = new ListTopicRequest();
        request.setRequestPath("topics/".split("/")[0]);
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        if (withMeta) {
            request.setWithMeta(withMeta);
        }
        return (PagingListResult)action.executeWithCustomHeaders(request, this.customHeaders);
    }

    @Override
    public PagingListResult<String> listTopicURL(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        PagingListResult<TopicMeta> results = this.listTopic(prefix, marker, retNumber, false);
        PagingListResult<String> ret = new PagingListResult<String>();
        if (results != null) {
            ArrayList<String> topics = new ArrayList<String>();
            for (TopicMeta meta : results.getResult()) {
                topics.add(meta.getTopicURL());
            }
            ret.setResult(topics);
            ret.setMarker(results.getMarker());
        }
        return ret;
    }
}

