/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure.datasource;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.pool.DruidDataSource;
import com.github.trang.druid.autoconfigure.properties.DruidDataSourceProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.datasource.druid")
public abstract class AbstractDruidDataSource2
extends DruidDataSource {
    private static final long serialVersionUID = -5155027912840793367L;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private DruidDataSourceProperties druidProperties;
    @Autowired
    private ObjectProvider<List<FilterAdapter>> druidFilters;

    @PostConstruct
    public void initDruidParentProperties() {
        this.initDataSourceProperties();
        this.initConnectionProperties();
        this.initFilters();
    }

    private void initDataSourceProperties() {
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getDriverClassName())) {
            super.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getUrl())) {
            super.setUrl(this.dataSourceProperties.getUrl());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getUsername())) {
            super.setUsername(this.dataSourceProperties.getUsername());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getPassword())) {
            super.setPassword(this.dataSourceProperties.getPassword());
        }
    }

    private void initConnectionProperties() {
        DruidDataSourceProperties.DruidEncodingFilterProperties encodingProperties;
        StringBuilder builder = new StringBuilder();
        DruidDataSourceProperties.DruidConfigFilterProperties configProperties = this.druidProperties.getConfig();
        if (configProperties.isEnabled()) {
            builder.append("config.decrypt").append("=").append("true").append(";");
            if (!StringUtils.isEmpty((Object)configProperties.getKey())) {
                builder.append("config.decrypt.key").append("=").append(configProperties.getKey()).append(";");
            }
            if (!StringUtils.isEmpty((Object)configProperties.getFile())) {
                builder.append("config.file").append("=").append(configProperties.getFile()).append(";");
            }
        }
        if ((encodingProperties = this.druidProperties.getEncoding()).isEnabled()) {
            if (!StringUtils.isEmpty((Object)encodingProperties.getClientEncoding())) {
                builder.append("clientEncoding").append("=").append(encodingProperties.getClientEncoding()).append(";");
            }
            if (!StringUtils.isEmpty((Object)encodingProperties.getServerEncoding())) {
                builder.append("serverEncoding").append("=").append(encodingProperties.getServerEncoding()).append(";");
            }
        }
        if (builder.length() > 0) {
            super.setConnectionProperties(builder.toString());
        }
    }

    private void initFilters() {
        List proxyFilters = super.getProxyFilters();
        ((List)this.druidFilters.getIfAvailable(ArrayList::new)).stream().filter(Objects::nonNull).filter(filter -> !proxyFilters.contains(filter)).forEach(proxyFilters::add);
    }
}

