/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.http.AbstractHttpClient;
import com.wechat.pay.java.core.http.AbstractHttpClientBuilder;
import com.wechat.pay.java.core.http.apache.ApacheHttpClientAdapter;
import java.util.Objects;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheHttpClientBuilder
implements AbstractHttpClientBuilder<ApacheHttpClientBuilder> {
    private Credential credential;
    private Validator validator;
    private CloseableHttpClient customizeApacheHttpClient;
    static PoolingHttpClientConnectionManager apacheHttpClientConnectionManager = new PoolingHttpClientConnectionManager();

    private CloseableHttpClient initDefaultApacheHttpClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)apacheHttpClientConnectionManager).setConnectionManagerShared(true).build();
    }

    @Override
    public ApacheHttpClientBuilder newInstance() {
        ApacheHttpClientBuilder result = new ApacheHttpClientBuilder();
        result.credential = this.credential;
        result.validator = this.validator;
        result.customizeApacheHttpClient = this.customizeApacheHttpClient;
        return result;
    }

    @Override
    public ApacheHttpClientBuilder credential(Credential credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder validator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public ApacheHttpClientBuilder apacheHttpClient(CloseableHttpClient apacheHttpClient) {
        this.customizeApacheHttpClient = apacheHttpClient;
        return this;
    }

    public ApacheHttpClientBuilder config(Config config) {
        Objects.requireNonNull(config);
        this.credential = config.createCredential();
        this.validator = config.createValidator();
        return this;
    }

    @Override
    public AbstractHttpClient build() {
        Objects.requireNonNull(this.credential);
        Objects.requireNonNull(this.validator);
        CloseableHttpClient httpclient = this.customizeApacheHttpClient == null ? this.initDefaultApacheHttpClient() : this.customizeApacheHttpClient;
        return new ApacheHttpClientAdapter(this.credential, this.validator, httpclient);
    }
}

