/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay2;

import com.jakewharton.rxrelay2.Relay;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishRelay<T>
extends Relay<T> {
    private static final PublishDisposable[] EMPTY = new PublishDisposable[0];
    private final AtomicReference<PublishDisposable<T>[]> subscribers = new AtomicReference<PublishDisposable[]>(EMPTY);

    public static <T> PublishRelay<T> create() {
        return new PublishRelay<T>();
    }

    private PublishRelay() {
    }

    public void subscribeActual(Observer<? super T> t) {
        PublishDisposable<T> ps = new PublishDisposable<T>(t, this);
        t.onSubscribe(ps);
        this.add(ps);
        if (ps.isDisposed()) {
            this.remove(ps);
        }
    }

    private void add(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            a = this.subscribers.get();
            int n = a.length;
            b = new PublishDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
    }

    void remove(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new PublishDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    @Override
    public void accept(T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        for (PublishDisposable<T> s : this.subscribers.get()) {
            s.onNext(value);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    static final class PublishDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 3562861878281475070L;
        final Observer<? super T> actual;
        final PublishRelay<T> parent;

        PublishDisposable(Observer<? super T> actual, PublishRelay<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        void onNext(T t) {
            if (!this.get()) {
                this.actual.onNext(t);
            }
        }

        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get();
        }
    }
}

