/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OIterableObject;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.common.util.OSupportsContains;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OMultiCollectionIterator<T>
implements Iterator<T>,
Iterable<T>,
OResettable,
OSizeable,
OSupportsContains,
OAutoConvertToRecord {
    private List<Object> sources;
    private Iterator<?> sourcesIterator;
    private Iterator<T> partialIterator;
    private int browsed = 0;
    private int skip = -1;
    private int limit = -1;
    private boolean embedded = false;
    private boolean autoConvert2Record = true;
    private int skipped = 0;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OMultiCollectionIterator() {
        this.sources = new ArrayList<Object>();
    }

    public OMultiCollectionIterator(Iterator<? extends Collection<?>> iterator) {
        this.sourcesIterator = iterator;
        this.getNextPartial();
    }

    @Override
    public boolean hasNext() {
        while (this.skipped < this.skip) {
            if (!this.hasNextInternal()) {
                return false;
            }
            this.partialIterator.next();
            ++this.skipped;
        }
        return this.hasNextInternal();
    }

    private boolean hasNextInternal() {
        if (this.sourcesIterator == null) {
            if (this.sources == null || this.sources.isEmpty()) {
                return false;
            }
            this.sourcesIterator = this.sources.iterator();
            this.getNextPartial();
        }
        if (this.partialIterator == null) {
            return false;
        }
        if (this.limit > -1 && this.browsed >= this.limit) {
            return false;
        }
        if (this.partialIterator.hasNext()) {
            return true;
        }
        if (this.sourcesIterator.hasNext()) {
            return this.getNextPartial();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.browsed;
        return this.partialIterator.next();
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public void reset() {
        this.sourcesIterator = null;
        this.partialIterator = null;
        this.browsed = 0;
        this.skipped = 0;
    }

    public OMultiCollectionIterator<T> add(Object iValue) {
        if (iValue != null) {
            if (this.sourcesIterator != null) {
                throw new IllegalStateException("MultiCollection iterator is in use and new collections cannot be added");
            }
            if (iValue instanceof OAutoConvertToRecord) {
                ((OAutoConvertToRecord)iValue).setAutoConvertToRecord(this.autoConvert2Record);
            }
            this.sources.add(iValue);
        }
        return this;
    }

    @Override
    public int size() {
        int size = 0;
        int totSources = this.sources.size();
        for (int i = 0; i < totSources; ++i) {
            Object o = this.sources.get(i);
            if (o == null) continue;
            if (o instanceof Collection) {
                size += ((Collection)o).size();
                continue;
            }
            if (o instanceof Map) {
                size += ((Map)o).size();
                continue;
            }
            if (o instanceof OSizeable) {
                size += ((OSizeable)o).size();
                continue;
            }
            if (o.getClass().isArray()) {
                size += Array.getLength(o);
                continue;
            }
            if (o instanceof Iterator && o instanceof OResettable) {
                while (((Iterator)o).hasNext()) {
                    ++size;
                    ((Iterator)o).next();
                }
                ((OResettable)o).reset();
                continue;
            }
            ++size;
        }
        return size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("OMultiCollectionIterator.remove()");
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    @Override
    public void setAutoConvertToRecord(boolean autoConvert2Record) {
        this.autoConvert2Record = autoConvert2Record;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvert2Record;
    }

    @Override
    public boolean supportsFastContains() {
        int totSources = this.sources.size();
        for (int i = 0; i < totSources; ++i) {
            Object o = this.sources.get(i);
            if (o == null || o instanceof Set || o instanceof ORidBag) continue;
            if (o instanceof OLazyWrapperIterator) {
                if (((OLazyWrapperIterator)o).canUseMultiValueDirectly()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean contains(Object value) {
        int totSources = this.sources.size();
        for (int i = 0; i < totSources; ++i) {
            Object o = this.sources.get(i);
            if (o == null) continue;
            if (o instanceof OLazyWrapperIterator) {
                o = ((OLazyWrapperIterator)o).getMultiValue();
            }
            if (!(o instanceof Collection ? ((Collection)o).contains(value) : o instanceof ORidBag && ((ORidBag)o).contains((OIdentifiable)value))) continue;
            return true;
        }
        return false;
    }

    protected boolean getNextPartial() {
        if (this.sourcesIterator != null) {
            while (this.sourcesIterator.hasNext()) {
                Object next = this.sourcesIterator.next();
                if (next == null) continue;
                if (!(next instanceof ODocument) && next instanceof Iterable) {
                    next = ((Iterable)next).iterator();
                }
                if (next instanceof OAutoConvertToRecord) {
                    ((OAutoConvertToRecord)next).setAutoConvertToRecord(this.autoConvert2Record);
                }
                if (next instanceof Iterator) {
                    if (next instanceof OResettable) {
                        ((OResettable)next).reset();
                    }
                    if (!((Iterator)next).hasNext()) continue;
                    this.partialIterator = (Iterator)next;
                    return true;
                }
                if (next instanceof Collection) {
                    if (((Collection)next).isEmpty()) continue;
                    this.partialIterator = ((Collection)next).iterator();
                    return true;
                }
                if (next.getClass().isArray()) {
                    int arraySize = Array.getLength(next);
                    if (arraySize <= 0) continue;
                    this.partialIterator = arraySize == 1 ? new OIterableObject<Object>(Array.get(next, 0)) : OMultiValue.getMultiValueIterator(next, false);
                    return true;
                }
                this.partialIterator = new OIterableObject<Object>(next);
                return true;
            }
        }
        return false;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public OMultiCollectionIterator<T> setEmbedded(boolean embedded) {
        this.embedded = embedded;
        return this;
    }

    public String toString() {
        return "[" + this.size() + "]";
    }
}

