/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OIndexOneEntryPerKeyLockManager<T>
implements OLockManager<T> {
    private static final Object NULL_KEY;
    private final ConcurrentHashMap<T, CountableLock> locks;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OIndexOneEntryPerKeyLockManager() {
        this(OGlobalConfiguration.ENVIRONMENT_LOCK_MANAGER_CONCURRENCY_LEVEL.getValueAsInteger());
    }

    public OIndexOneEntryPerKeyLockManager(int concurrencyLevel) {
        int ceilingConcurrencyLevel = OIndexOneEntryPerKeyLockManager.ceilingPowerOf2(concurrencyLevel);
        this.locks = new ConcurrentHashMap(16, 0.75f, ceilingConcurrencyLevel);
    }

    @Override
    public Lock acquireSharedLock(T key) {
        return this.acquireLock(key, true);
    }

    @Override
    public void releaseSharedLock(T key) {
        this.releaseLock(key, true);
    }

    @Override
    public Lock acquireExclusiveLock(T key) {
        return this.acquireLock(key, false);
    }

    @Override
    public void releaseExclusiveLock(T key) {
        this.releaseLock(key, false);
    }

    @Override
    public Lock[] acquireSharedLocksInBatch(T ... keys) {
        return this.acquireLockInBatch(keys, true);
    }

    @Override
    public Lock[] acquireExclusiveLocksInBatch(T ... keys) {
        return this.acquireLockInBatch(keys, false);
    }

    @Override
    public Lock[] acquireExclusiveLocksInBatch(Collection<T> keys) {
        if (keys == null || keys.isEmpty()) {
            return new Lock[0];
        }
        ArrayList<Comparable> comparables = new ArrayList<Comparable>();
        int seenNulls = 0;
        for (T key : keys) {
            if (key instanceof Comparable) {
                comparables.add((Comparable)key);
                continue;
            }
            if (key == null) {
                ++seenNulls;
                continue;
            }
            throw new IllegalArgumentException("In order to lock a key in a batch it should implement " + Comparable.class.getName() + " interface");
        }
        Collections.sort(comparables);
        Lock[] locks = new Lock[comparables.size() + seenNulls];
        int i = 0;
        for (int j = 0; j < seenNulls; ++j) {
            locks[i++] = this.acquireExclusiveLock(NULL_KEY);
        }
        for (Comparable key : comparables) {
            locks[i++] = this.acquireExclusiveLock(key);
        }
        return locks;
    }

    @Override
    public void lockAllExclusive() {
        for (CountableLock lock : this.locks.values()) {
            lock.readWriteLock.writeLock().lock();
        }
    }

    @Override
    public void unlockAllExclusive() {
        for (CountableLock lock : this.locks.values()) {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    private Lock acquireLock(T key, boolean read) {
        CountableLock lock;
        if ((key = this.immutalizeKey(key)) == null) {
            key = NULL_KEY;
        }
        do {
            if ((lock = this.locks.get(key)) == null) continue;
            int oldLevel = lock.level.get();
            if (oldLevel >= 0) {
                if (!lock.level.compareAndSet(oldLevel, oldLevel + 1)) continue;
                break;
            }
            this.locks.remove(key, lock);
        } while (lock != null);
        if (lock == null) {
            CountableLock oldLock;
            while ((oldLock = this.locks.putIfAbsent(key, lock = new CountableLock())) != null) {
                lock = oldLock;
                int oldLevel = lock.level.get();
                if (oldLevel >= 0) {
                    if (!lock.level.compareAndSet(oldLevel, oldLevel + 1)) continue;
                    assert (this.locks.get(key) == lock);
                    break;
                }
                this.locks.remove(key, lock);
            }
        }
        if (read) {
            lock.readWriteLock.readLock().lock();
        } else {
            lock.readWriteLock.writeLock().lock();
        }
        return new CountableLockWrapper<T>(key, lock, this.locks, read);
    }

    private void releaseLock(T key, boolean read) throws OLockException {
        CountableLock lock;
        if ((key = this.immutalizeKey(key)) == null) {
            key = NULL_KEY;
        }
        if ((lock = this.locks.get(key)) == null) {
            throw new OLockException("Error on releasing a non acquired lock by thread '" + Thread.currentThread() + "' against the resource: '" + key + "'");
        }
        if (lock.level.decrementAndGet() == 0 && lock.level.compareAndSet(0, -1)) {
            assert (lock.level.get() == -1);
            this.locks.remove(key, lock);
        }
        if (read) {
            lock.readWriteLock.readLock().unlock();
        } else {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    private Lock[] acquireLockInBatch(T[] keys, boolean read) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        ArrayList<Comparable> comparables = new ArrayList<Comparable>();
        int seenNulls = 0;
        for (T t : keys) {
            if (t instanceof Comparable) {
                comparables.add((Comparable)t);
                continue;
            }
            if (t == null) {
                ++seenNulls;
                continue;
            }
            throw new IllegalArgumentException("In order to lock a key in a batch it should implement " + Comparable.class.getName() + " interface");
        }
        Collections.sort(comparables);
        Lock[] locks = new Lock[comparables.size() + seenNulls];
        int i = 0;
        for (int j = 0; j < seenNulls; ++j) {
            locks[i++] = read ? this.acquireSharedLock(NULL_KEY) : this.acquireExclusiveLock(NULL_KEY);
        }
        for (Comparable comparable : comparables) {
            locks[i++] = read ? this.acquireSharedLock(comparable) : this.acquireExclusiveLock(comparable);
        }
        return locks;
    }

    private T immutalizeKey(T key) {
        if (key instanceof OIdentifiable) {
            return (T)((OIdentifiable)key).getIdentity().copy();
        }
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            boolean needsCopy = false;
            for (Object subkey : compositeKey.getKeys()) {
                assert (!(subkey instanceof OCompositeKey));
                if (!(subkey instanceof OIdentifiable)) continue;
                needsCopy = true;
                break;
            }
            if (needsCopy) {
                OCompositeKey copy = new OCompositeKey();
                for (Object subkey : compositeKey.getKeys()) {
                    copy.addKey(subkey instanceof OIdentifiable ? ((OIdentifiable)subkey).getIdentity().copy() : subkey);
                }
                return (T)copy;
            }
            return key;
        }
        return key;
    }

    public int getLockCount() {
        return this.locks.size();
    }

    private static int ceilingPowerOf2(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    static {
        try {
            try {
                NULL_KEY = new Object();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class CountableLockWrapper<T>
    implements Lock {
        private final T key;
        private final CountableLock lock;
        private final ConcurrentHashMap<T, CountableLock> locks;
        private final boolean read;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public CountableLockWrapper(T key, CountableLock lock, ConcurrentHashMap<T, CountableLock> locks, boolean read) {
            this.key = key;
            this.lock = lock;
            this.locks = locks;
            this.read = read;
        }

        @Override
        public void lock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            assert (this.lock == this.locks.get(this.key));
            if (this.lock.level.decrementAndGet() == 0 && this.lock.level.compareAndSet(0, -1)) {
                assert (this.lock.level.get() == -1);
                this.locks.remove(this.key, this.lock);
            }
            if (this.read) {
                this.lock.readWriteLock.readLock().unlock();
            } else {
                this.lock.readWriteLock.writeLock().unlock();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        static {
            try {
                try {
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    private static class CountableLock {
        public final AtomicInteger level = new AtomicInteger(1);
        public final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private CountableLock() {
        }
    }
}

