/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OConsoleApplication;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class TTYConsoleReader
implements OConsoleReader {
    private static final String HISTORY_FILE_NAME = ".orientdb_history";
    public static final int END_CHAR = 70;
    public static final int BEGIN_CHAR = 72;
    public static final int DEL_CHAR = 126;
    public static final int DOWN_CHAR = 66;
    public static final int UP_CHAR = 65;
    public static final int RIGHT_CHAR = 67;
    public static final int LEFT_CHAR = 68;
    public static final int HORIZONTAL_TAB_CHAR = 9;
    public static final int VERTICAL_TAB_CHAR = 11;
    public static final int BACKSPACE_CHAR = 127;
    public static final int NEW_LINE_CHAR = 10;
    public static final int UNIT_SEPARATOR_CHAR = 31;
    private static final int MAX_HISTORY_ENTRIES = 50;
    private static final Object signalLock;
    private static int cachedConsoleWidth;
    protected int cursorPosition = 0;
    protected int oldPromptLength = 0;
    protected int oldTextLength = 0;
    protected int oldCursorPosition = 0;
    protected int maxTotalLength = 0;
    protected final List<String> history = new ArrayList<String>();
    protected String historyBuffer;
    protected Reader inStream;
    protected PrintStream outStream;
    protected OConsoleApplication console;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public TTYConsoleReader() {
        File file = this.getHistoryFile(true);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String historyEntry = reader.readLine();
            while (historyEntry != null) {
                this.history.add(historyEntry);
                historyEntry = reader.readLine();
            }
            if (System.getProperty("file.encoding") != null) {
                this.inStream = new InputStreamReader(System.in, System.getProperty("file.encoding"));
                this.outStream = new PrintStream((OutputStream)System.out, false, System.getProperty("file.encoding"));
            } else {
                this.inStream = new InputStreamReader(System.in);
                this.outStream = System.out;
            }
        }
        catch (FileNotFoundException fnfe) {
            OLogManager.instance().error(this, "History file not found", fnfe, new Object[0]);
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error reading history file", ioe, new Object[0]);
        }
        if (this.inStream == null) {
            throw new OSystemException("Cannot access to the input stream. Check permissions of running process");
        }
    }

    @Override
    public String readPassword() throws IOException {
        return this.readLine();
    }

    @Override
    public String readLine() throws IOException {
        String consoleInput = "";
        StringBuffer buffer = new StringBuffer();
        this.cursorPosition = 0;
        this.historyBuffer = null;
        int historyNum = this.history.size();
        boolean hintedHistory = false;
        while (true) {
            boolean escape = false;
            boolean ctrl = false;
            int next = this.inStream.read();
            if (next == 27) {
                escape = true;
                this.inStream.read();
                next = this.inStream.read();
            }
            if (escape) {
                if (next == 49) {
                    this.inStream.read();
                    next = this.inStream.read();
                }
                if (next == 53) {
                    ctrl = true;
                    next = this.inStream.read();
                }
                if (ctrl) {
                    if (next == 67) {
                        this.cursorPosition = buffer.indexOf(" ", this.cursorPosition) + 1;
                        if (this.cursorPosition == 0) {
                            this.cursorPosition = buffer.length();
                        }
                        this.updatePrompt(buffer);
                        continue;
                    }
                    if (next != 68) continue;
                    this.cursorPosition = this.cursorPosition > 1 && this.cursorPosition < buffer.length() && buffer.charAt(this.cursorPosition - 1) == ' ' ? buffer.lastIndexOf(" ", this.cursorPosition - 2) + 1 : buffer.lastIndexOf(" ", this.cursorPosition) + 1;
                    if (this.cursorPosition < 0) {
                        this.cursorPosition = 0;
                    }
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next == 65 && !this.history.isEmpty()) {
                    if (this.history.size() <= 0) continue;
                    if (!(hintedHistory || historyNum != this.history.size() && buffer.toString().equals(this.history.get(historyNum)))) {
                        if (buffer.length() > 0) {
                            hintedHistory = true;
                            this.historyBuffer = buffer.toString();
                        } else {
                            this.historyBuffer = null;
                        }
                    }
                    buffer = (historyNum = this.getHintedHistoryIndexUp(historyNum)) > -1 ? new StringBuffer(this.history.get(historyNum)) : new StringBuffer(this.historyBuffer);
                    this.cursorPosition = buffer.length();
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next == 66 && !this.history.isEmpty()) {
                    if (this.history.size() <= 0) continue;
                    buffer = (historyNum = this.getHintedHistoryIndexDown(historyNum)) == this.history.size() ? (this.historyBuffer != null ? new StringBuffer(this.historyBuffer) : new StringBuffer("")) : new StringBuffer(this.history.get(historyNum));
                    this.cursorPosition = buffer.length();
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next == 67) {
                    if (this.cursorPosition >= buffer.length()) continue;
                    ++this.cursorPosition;
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next == 68) {
                    if (this.cursorPosition <= 0) continue;
                    --this.cursorPosition;
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next == 70) {
                    this.cursorPosition = buffer.length();
                    this.updatePrompt(buffer);
                    continue;
                }
                if (next != 72) continue;
                this.cursorPosition = 0;
                this.updatePrompt(buffer);
                continue;
            }
            if (next == 10) break;
            if (next == 127) {
                if (buffer.length() > 0 && this.cursorPosition > 0) {
                    buffer.deleteCharAt(this.cursorPosition - 1);
                    --this.cursorPosition;
                    this.updatePrompt(buffer);
                }
            } else if (next == 126) {
                if (buffer.length() > 0 && this.cursorPosition >= 0 && this.cursorPosition < buffer.length()) {
                    buffer.deleteCharAt(this.cursorPosition);
                    this.updatePrompt(buffer);
                }
            } else if (next == 9) {
                buffer = this.writeHint(buffer);
                this.cursorPosition = buffer.length();
                this.updatePrompt(buffer);
            } else if (next > 31 && next < 127 || next > 127) {
                if (this.cursorPosition == buffer.length()) {
                    buffer.append((char)next);
                } else {
                    buffer.insert(this.cursorPosition, (char)next);
                }
                ++this.cursorPosition;
                this.updatePrompt(buffer);
            } else {
                this.outStream.println();
                this.outStream.print(buffer);
            }
            historyNum = this.history.size();
            hintedHistory = false;
        }
        this.outStream.println();
        this.oldPromptLength = 0;
        this.oldTextLength = 0;
        this.oldCursorPosition = 0;
        this.maxTotalLength = 0;
        consoleInput = buffer.toString();
        this.history.remove(consoleInput);
        this.history.add(consoleInput);
        historyNum = this.history.size();
        this.writeHistory(historyNum);
        if (consoleInput.equals("clear")) {
            this.outStream.flush();
            for (int i = 0; i < 150; ++i) {
                this.outStream.println();
            }
            this.outStream.print("\r");
            this.outStream.print(this.console.getPrompt());
            return this.readLine();
        }
        return consoleInput;
    }

    @Override
    public void setConsole(OConsoleApplication iConsole) {
        this.console = iConsole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConsoleWidth() {
        Object object = signalLock;
        synchronized (object) {
            if (cachedConsoleWidth > 0) {
                return cachedConsoleWidth;
            }
            if (cachedConsoleWidth == -1) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "tput cols 2> /dev/tty"});
                    String line = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                    process.waitFor();
                    cachedConsoleWidth = process.exitValue() == 0 && line != null ? Integer.parseInt(line) : -2;
                }
                catch (IOException ignore) {
                    cachedConsoleWidth = -2;
                }
                catch (InterruptedException ignore) {
                    cachedConsoleWidth = -2;
                }
                catch (NumberFormatException ignore) {
                    cachedConsoleWidth = -2;
                }
            }
            return cachedConsoleWidth == -2 || cachedConsoleWidth == 0 ? 150 : cachedConsoleWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(int historyNum) throws IOException {
        if (historyNum <= 50) {
            File historyFile = this.getHistoryFile(false);
            BufferedWriter writer = new BufferedWriter(new FileWriter(historyFile));
            try {
                for (String historyEntry : this.history) {
                    writer.write(historyEntry);
                    writer.newLine();
                }
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
        File historyFile = this.getHistoryFile(false);
        BufferedWriter writer = new BufferedWriter(new FileWriter(historyFile));
        try {
            for (String historyEntry : this.history.subList(historyNum - 50 - 1, historyNum - 1)) {
                writer.write(historyEntry);
                writer.newLine();
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private StringBuffer writeHint(StringBuffer buffer) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Method method : this.console.getConsoleMethods().keySet()) {
            String command = OConsoleApplication.getClearName(method.getName());
            if (!command.startsWith(buffer.toString())) continue;
            suggestions.add(command);
        }
        if (suggestions.size() > 1) {
            StringBuffer hintBuffer = new StringBuffer();
            String[] bufferComponents = buffer.toString().split(" ");
            HashSet<String> bufferPart = new HashSet<String>();
            String suggestionPart = null;
            boolean appendSpace = true;
            for (String suggestion : suggestions) {
                int i;
                String[] suggestionComponents = suggestion.split(" ");
                hintBuffer.append("* " + suggestion + " ");
                hintBuffer.append("\n");
                suggestionPart = "";
                if (bufferComponents.length == 0 || buffer.length() == 0) {
                    suggestionPart = null;
                    continue;
                }
                if (bufferComponents.length == 1) {
                    bufferPart.add(suggestionComponents[0]);
                    if (bufferPart.size() > 1) {
                        suggestionPart = bufferComponents[0];
                        appendSpace = false;
                        continue;
                    }
                    suggestionPart = suggestionComponents[0];
                    continue;
                }
                bufferPart.add(suggestionComponents[bufferComponents.length - 1]);
                if (bufferPart.size() > 1) {
                    for (i = 0; i < bufferComponents.length; ++i) {
                        suggestionPart = suggestionPart + bufferComponents[i];
                        if (i < bufferComponents.length - 1) {
                            suggestionPart = suggestionPart + " ";
                        }
                        appendSpace = false;
                    }
                    continue;
                }
                for (i = 0; i < suggestionComponents.length; ++i) {
                    suggestionPart = suggestionPart + suggestionComponents[i] + " ";
                }
            }
            if (suggestionPart != null) {
                buffer = new StringBuffer();
                buffer.append(suggestionPart);
                if (appendSpace) {
                    buffer.append(" ");
                }
            }
            hintBuffer.append("-----------------------------\n");
            this.updateHints(hintBuffer);
        } else if (suggestions.size() > 0) {
            buffer = new StringBuffer();
            buffer.append((String)suggestions.get(0));
            buffer.append(" ");
        }
        return buffer;
    }

    private void updatePrompt(StringBuffer newText) {
        int consoleWidth = this.getConsoleWidth();
        String newPrompt = this.console.getPrompt();
        int newTotalLength = newPrompt.length() + newText.length();
        int oldTotalLength = this.oldPromptLength + this.oldTextLength;
        this.hideCursor();
        this.outStream.print("\r");
        this.moveCursorVertically(-this.getWraps(this.oldPromptLength, this.oldCursorPosition, consoleWidth));
        this.outStream.print(newPrompt);
        this.outStream.print(newText);
        StringBuilder spaces = new StringBuilder();
        int promptLengthDelta = oldTotalLength - newTotalLength;
        for (int i = 0; i < promptLengthDelta; ++i) {
            spaces.append(' ');
        }
        this.outStream.print(spaces);
        this.outStream.print("\r");
        if (newTotalLength > oldTotalLength) {
            if (newTotalLength > this.maxTotalLength && newTotalLength % consoleWidth == 0) {
                this.outStream.print('\n');
                this.moveCursorVertically(-1);
            }
            this.moveCursorVertically(-this.getWraps(newPrompt.length(), newText.length() - 1, consoleWidth));
        } else {
            this.moveCursorVertically(-this.getWraps(this.oldPromptLength, this.oldTextLength - 1, consoleWidth));
        }
        this.moveCursorVertically((newPrompt.length() + this.cursorPosition) / consoleWidth);
        this.moveCursorHorizontally((newPrompt.length() + this.cursorPosition) % consoleWidth);
        this.oldPromptLength = newPrompt.length();
        this.oldTextLength = newText.length();
        this.oldCursorPosition = this.cursorPosition;
        this.maxTotalLength = Math.max(newTotalLength, this.maxTotalLength);
        this.showCursor();
    }

    private void erasePrompt() {
        int consoleWidth = this.getConsoleWidth();
        int oldTotalLength = this.oldPromptLength + this.oldTextLength;
        this.hideCursor();
        this.outStream.print("\r");
        this.moveCursorVertically(-this.getWraps(this.oldPromptLength, this.oldCursorPosition, consoleWidth));
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < oldTotalLength; ++i) {
            spaces.append(' ');
        }
        this.outStream.print(spaces);
        this.outStream.print("\r");
        this.moveCursorVertically(-this.getWraps(this.oldPromptLength, this.oldCursorPosition, consoleWidth));
        this.oldPromptLength = 0;
        this.oldTextLength = 0;
        this.oldCursorPosition = 0;
        this.maxTotalLength = 0;
        this.showCursor();
    }

    private void updateHints(StringBuffer hints) {
        this.erasePrompt();
        this.outStream.print("\r");
        this.outStream.print(hints);
    }

    private int getWraps(int promptLength, int cursorPosition, int consoleWidth) {
        return (promptLength + Math.max(0, cursorPosition)) / consoleWidth;
    }

    private void hideCursor() {
        this.outStream.print("\u001b[?25l");
    }

    private void showCursor() {
        this.outStream.print("\u001b[?25h");
    }

    private void moveCursorHorizontally(int delta) {
        if (delta > 0) {
            this.outStream.print("\u001b[" + delta + "C");
        } else if (delta < 0) {
            this.outStream.print("\u001b[" + Math.abs(delta) + "D");
        }
    }

    private void moveCursorVertically(int delta) {
        if (delta > 0) {
            this.outStream.print("\u001b[" + delta + "B");
        } else if (delta < 0) {
            this.outStream.print("\u001b[" + Math.abs(delta) + "A");
        }
    }

    private int getHintedHistoryIndexUp(int historyNum) {
        if (this.historyBuffer != null && !this.historyBuffer.equals("")) {
            for (int i = historyNum - 1; i >= 0; --i) {
                if (!this.history.get(i).startsWith(this.historyBuffer)) continue;
                return i;
            }
            return -1;
        }
        return historyNum > 0 ? historyNum - 1 : 0;
    }

    private int getHintedHistoryIndexDown(int historyNum) throws IOException {
        if (this.historyBuffer != null && !this.historyBuffer.equals("")) {
            for (int i = historyNum + 1; i < this.history.size(); ++i) {
                if (!this.history.get(i).startsWith(this.historyBuffer)) continue;
                return i;
            }
            return this.history.size();
        }
        return historyNum < this.history.size() ? historyNum + 1 : this.history.size();
    }

    private File getHistoryFile(boolean read) {
        File file = new File(HISTORY_FILE_NAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Error creating history file", ioe, new Object[0]);
            }
        } else if (!read) {
            file.delete();
            try {
                file.createNewFile();
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Error creating history file", ioe, new Object[0]);
            }
        }
        return file;
    }

    static {
        try {
            try {
                signalLock = new Object();
                cachedConsoleWidth = -1;
                try {
                    Signal signal = new Signal("WINCH");
                    Signal.handle(signal, new SignalHandler(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handle(Signal signal) {
                            Object object = signalLock;
                            synchronized (object) {
                                cachedConsoleWidth = -1;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    OLogManager.instance().warn(null, "Cannot manage SIGWINCH on this system", new Object[0]);
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

