/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.exception;

import com.orientechnologies.common.exception.OErrorCategory;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OBackupInProgressException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import java.lang.reflect.InvocationTargetException;

public final class OErrorCode
extends Enum<OErrorCode> {
    public static final /* enum */ OErrorCode QUERY_PARSE_ERROR;
    public static final /* enum */ OErrorCode BACKUP_IN_PROGRESS;
    protected final OErrorCategory category;
    protected final int code;
    protected final String description;
    protected final Class<? extends OException> exceptionClass;
    private static final /* synthetic */ OErrorCode[] $VALUES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static OErrorCode[] values() {
        return (OErrorCode[])$VALUES.clone();
    }

    public static OErrorCode valueOf(String name) {
        return Enum.valueOf(OErrorCode.class, name);
    }

    private OErrorCode(OErrorCategory category, int code, String description) {
        this(category, code, description, OException.class);
    }

    private OErrorCode(OErrorCategory category, int code, String description, Class<? extends OException> exceptionClass) {
        this.category = category;
        this.code = code;
        this.description = description;
        this.exceptionClass = exceptionClass;
    }

    public int getCode() {
        return this.code;
    }

    public void throwException() {
        this.throwException(this.description, null);
    }

    public void throwException(String message) {
        this.throwException(message, null);
    }

    public void throwException(Throwable parent) {
        this.throwException(this.description, parent);
    }

    public void throwException(String message, Throwable parent) {
        try {
            OException exc = OException.wrapException(this.exceptionClass.getConstructor(String.class).newInstance(message), parent);
            throw exc;
        }
        catch (InstantiationException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, e, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, e, new Object[0]);
        }
    }

    static {
        try {
            try {
                QUERY_PARSE_ERROR = new OErrorCode(OErrorCategory.SQL_PARSING, 1, "query parse error", OQueryParsingException.class);
                BACKUP_IN_PROGRESS = new OErrorCode(OErrorCategory.STORAGE, 2, "You are trying to start a backup, but it is already in progress", OBackupInProgressException.class);
                $VALUES = new OErrorCode[]{QUERY_PARSE_ERROR, BACKUP_IN_PROGRESS};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

