/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OLogFormatter
extends Formatter {
    protected static final DateFormat dateFormat;
    protected static final String EOL;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() == null) {
            return this.customFormatMessage(record);
        }
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(record.getMessage());
        Throwable current = record.getThrown();
        if (current != null) {
            buffer.append(EOL);
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            current.printStackTrace(printWriter);
            printWriter.flush();
            buffer.append(writer.getBuffer());
            printWriter.close();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String customFormatMessage(LogRecord iRecord) {
        Level level = iRecord.getLevel();
        String message = OAnsiCode.format(iRecord.getMessage(), false);
        Object[] additionalArgs = iRecord.getParameters();
        String requester = this.getSourceClassSimpleName(iRecord.getLoggerName());
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(EOL);
        DateFormat dateFormat = OLogFormatter.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OLogFormatter.dateFormat.format(new Date()));
        }
        buffer.append(String.format(" %-5.5s ", level.getName()));
        try {
            if (additionalArgs != null) {
                buffer.append(String.format(message, additionalArgs));
            } else {
                buffer.append(message);
            }
        }
        catch (IllegalFormatException ignore) {
            buffer.append(message);
        }
        if (requester != null) {
            buffer.append(" [");
            buffer.append(requester);
            buffer.append(']');
        }
        return OAnsiCode.format(buffer.toString(), false);
    }

    protected String getSourceClassSimpleName(String iSourceClassName) {
        if (iSourceClassName == null) {
            return null;
        }
        return iSourceClassName.substring(iSourceClassName.lastIndexOf(".") + 1);
    }

    static {
        try {
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                EOL = System.getProperty("line.separator");
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

