/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OLongSerializer
implements OBinarySerializer<Long> {
    public static final byte ID = 10;
    public static final int LONG_SIZE = 8;
    private static final OBinaryConverter CONVERTER;
    public static final OLongSerializer INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(Long object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Long object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    public void serializeLiteral(long value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 56 & 0xFFL);
        stream[startPosition + 1] = (byte)(value >>> 48 & 0xFFL);
        stream[startPosition + 2] = (byte)(value >>> 40 & 0xFFL);
        stream[startPosition + 3] = (byte)(value >>> 32 & 0xFFL);
        stream[startPosition + 4] = (byte)(value >>> 24 & 0xFFL);
        stream[startPosition + 5] = (byte)(value >>> 16 & 0xFFL);
        stream[startPosition + 6] = (byte)(value >>> 8 & 0xFFL);
        stream[startPosition + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    @Override
    public Long deserialize(byte[] stream, int startPosition) {
        return this.deserializeLiteral(stream, startPosition);
    }

    public long deserializeLiteral(byte[] stream, int startPosition) {
        return (long)(0xFF & stream[startPosition + 7] | (0xFF & stream[startPosition + 6]) << 8 | (0xFF & stream[startPosition + 5]) << 16) | (long)(0xFF & stream[startPosition + 4]) << 24 | (long)(0xFF & stream[startPosition + 3]) << 32 | (long)(0xFF & stream[startPosition + 2]) << 40 | (long)(0xFF & stream[startPosition + 1]) << 48 | (long)(0xFF & stream[startPosition]) << 56;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 10;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNativeObject(Long object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putLong(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Long deserializeNativeObject(byte[] stream, int startPosition) {
        return CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder());
    }

    public void serializeNative(long object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putLong(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public long deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Long preprocess(Long value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Long object, ByteBuffer buffer, Object ... hints) {
        buffer.putLong(object);
    }

    @Override
    public Long deserializeFromByteBufferObject(ByteBuffer buffer) {
        return buffer.getLong();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 8;
    }

    @Override
    public Long deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getLongValue(buffer, offset);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 8;
    }

    static {
        try {
            try {
                CONVERTER = OBinaryConverterFactory.getConverter();
                INSTANCE = new OLongSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

