/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.log.OLogManager;
import java.lang.reflect.Array;

public class OArrays {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static <T> T[] copyOf(T[] iSource, int iNewSize) {
        return OArrays.copyOf(iSource, iNewSize, iSource.getClass());
    }

    public static <T, U> T[] copyOf(U[] iSource, int iNewSize, Class<? extends T[]> iNewType) {
        Object[] copy = iNewType == Object[].class ? new Object[iNewSize] : (Object[])Array.newInstance(iNewType.getComponentType(), iNewSize);
        System.arraycopy(iSource, 0, copy, 0, Math.min(iSource.length, iNewSize));
        return copy;
    }

    public static <S> S[] copyOfRange(S[] iSource, int iBegin, int iEnd) {
        return OArrays.copyOfRange(iSource, iBegin, iEnd, iSource.getClass());
    }

    public static <D, S> D[] copyOfRange(S[] iSource, int iBegin, int iEnd, Class<? extends D[]> iClass) {
        int newLength = iEnd - iBegin;
        if (newLength < 0) {
            throw new IllegalArgumentException(iBegin + " > " + iEnd);
        }
        Object[] copy = iClass == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(iClass.getComponentType(), newLength);
        System.arraycopy(iSource, iBegin, copy, 0, Math.min(iSource.length - iBegin, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] iSource, int iBegin, int iEnd) {
        int newLength = iEnd - iBegin;
        if (newLength < 0) {
            throw new IllegalArgumentException(iBegin + " > " + iEnd);
        }
        try {
            byte[] copy = new byte[newLength];
            System.arraycopy(iSource, iBegin, copy, 0, Math.min(iSource.length - iBegin, newLength));
            return copy;
        }
        catch (OutOfMemoryError e) {
            OLogManager.instance().error(null, "Error on copying buffer of size %d bytes", e, newLength);
            throw e;
        }
    }

    public static int[] copyOf(int[] iSource, int iNewSize) {
        int[] copy = new int[iNewSize];
        System.arraycopy(iSource, 0, copy, 0, Math.min(iSource.length, iNewSize));
        return copy;
    }

    public static boolean contains(int[] iArray, int iToFind) {
        if (iArray == null || iArray.length == 0) {
            return false;
        }
        for (int e : iArray) {
            if (e != iToFind) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] iArray, T iToFind) {
        if (iArray == null || iArray.length == 0) {
            return false;
        }
        for (T e : iArray) {
            if (e == null || !e.equals(iToFind)) continue;
            return true;
        }
        return false;
    }

    public static int hash(Object[] iArray) {
        int hash = 0;
        for (Object o : iArray) {
            if (o == null) continue;
            hash += o.hashCode();
        }
        return hash;
    }
}

