/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OSQLDumper;
import java.util.Collection;

public class OUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public void uncaughtException(Thread thread, Throwable e) {
        OLogManager logManager = OLogManager.instance();
        if (logManager != null) {
            OLogManager.instance().errorNoDb(this, "Uncaught exception in thread %s", e, thread.getName());
            if (e instanceof OutOfMemoryError) {
                Collection<String> queries = OSQLDumper.dumpAllSQLQueries();
                if (queries.isEmpty()) {
                    OLogManager.instance().errorNoDb(this, "Uncaught exception in thread %s", e, thread.getName());
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("OOM Error was thrown by JVM. OOM can be caused by one of the following queries: \n");
                    sb.append("-----------------------------------------------------------------------------------\n");
                    for (String query : queries) {
                        sb.append("- '").append(query).append("'\n");
                    }
                    sb.append("-----------------------------------------------------------------------------------\n");
                    OLogManager.instance().errorNoDb(this, sb.toString(), e, new Object[0]);
                }
            } else {
                OLogManager.instance().errorNoDb(this, "Uncaught exception in thread %s", e, thread.getName());
            }
        }
    }
}

