/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.log.OLogManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class OConstants {
    public static final String ORIENT_URL = "https://www.orientdb.com";
    public static final String COPYRIGHT = "Copyrights (c) 2017 OrientDB LTD";
    @Deprecated
    public static volatile String ORIENT_VERSION;
    @Deprecated
    public static final String GROUPID = "com.orientechnologies";
    @Deprecated
    public static final String ARTIFACTID = "orientdb-core";
    @Deprecated
    public static final String REVISION;
    @Deprecated
    public static final int ORIENT_VERSION_MAJOR;
    @Deprecated
    public static final int ORIENT_VERSION_MINOR;
    @Deprecated
    public static final int ORIENT_VERSION_HOFIX;
    private static final Properties properties;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static int getVersionMajor() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length == 0) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve version information for this build", null, new Object[0]);
            return -1;
        }
        try {
            return Integer.parseInt(versions[0]);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve major version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static int getVersionMinor() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length < 2) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve minor version information for this build", null, new Object[0]);
            return -1;
        }
        try {
            return Integer.parseInt(versions[1]);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve minor version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static int getVersionHotfix() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length < 3) {
            return 0;
        }
        try {
            String hotfix = versions[2];
            int snapshotIndex = hotfix.indexOf("-SNAPSHOT");
            if (snapshotIndex != -1) {
                hotfix = hotfix.substring(0, snapshotIndex);
            }
            return Integer.parseInt(hotfix);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve hotfix version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static String getRawVersion() {
        return properties.getProperty("version");
    }

    public static String getVersion() {
        return properties.getProperty("version") + " (build " + properties.getProperty("revision") + ", branch " + properties.getProperty("branch") + ")";
    }

    @Deprecated
    public static int[] getVersionNumber() {
        return new int[]{ORIENT_VERSION_MAJOR, ORIENT_VERSION_MINOR, ORIENT_VERSION_HOFIX};
    }

    public static boolean isSnapshot() {
        return properties.getProperty("version").endsWith("SNAPSHOT");
    }

    public static String getBuildNumber() {
        return properties.getProperty("revision");
    }

    static {
        try {
            try {
                properties = new Properties();
                try {
                    InputStream inputStream = OConstants.class.getResourceAsStream("/com/orientechnologies/orientdb.properties");
                    try {
                        properties.load(inputStream);
                    }
                    catch (IOException e) {
                        OLogManager.instance().error(OConstants.class, "Failed to load OrientDB properties", e, new Object[0]);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    ORIENT_VERSION = OConstants.getRawVersion();
                    REVISION = OConstants.getBuildNumber();
                    ORIENT_VERSION_MAJOR = OConstants.getVersionMajor();
                    ORIENT_VERSION_MINOR = OConstants.getVersionMinor();
                    ORIENT_VERSION_HOFIX = OConstants.getVersionHotfix();
                }
                catch (Exception e) {
                    OLogManager.instance().errorNoDb(null, "Error during OrientDB constants initialization", e, new Object[0]);
                    throw new RuntimeException(e);
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

