/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.ORecordCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.HashSet;

public abstract class OAbstractRecordCache {
    protected ORecordCache underlying;
    protected String profilerPrefix = "noname";
    protected String profilerMetadataPrefix = "noname";
    protected int excludedCluster = -1;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OAbstractRecordCache(ORecordCache impl) {
        this.underlying = impl;
    }

    public boolean isEnabled() {
        return this.underlying.isEnabled();
    }

    public void setEnable(boolean enable) {
        if (enable) {
            this.underlying.enable();
        } else {
            this.underlying.disable();
        }
    }

    public ORecord freeRecord(ORID rid) {
        return this.underlying.remove(rid);
    }

    public void freeCluster(int cid) {
        HashSet<ORID> toRemove = new HashSet<ORID>(this.underlying.size() / 2);
        HashSet<ORID> keys = new HashSet<ORID>(this.underlying.keys());
        for (ORID id : keys) {
            if (id.getClusterId() != cid) continue;
            toRemove.add(id);
        }
        for (ORID ridToRemove : toRemove) {
            this.underlying.remove(ridToRemove);
        }
    }

    public void deleteRecord(ORID rid) {
        this.underlying.remove(rid);
    }

    public void clear() {
        this.underlying.clear();
    }

    public int getSize() {
        return this.underlying.size();
    }

    public void startup() {
        this.underlying.startup();
        Orient.instance().getProfiler().registerHookValue(this.profilerPrefix + "current", "Number of entries in cache", OProfiler.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object getValue() {
                return OAbstractRecordCache.this.getSize();
            }
        }, this.profilerMetadataPrefix + "current");
    }

    public void shutdown() {
        this.underlying.shutdown();
        if (Orient.instance().getProfiler() != null) {
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "enabled");
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "current");
            Orient.instance().getProfiler().unregisterHookValue(this.profilerPrefix + "max");
        }
    }
}

