/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;

public class OLocalRecordCache
extends OAbstractRecordCache {
    private String CACHE_HIT;
    private String CACHE_MISS;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OLocalRecordCache() {
        super(Orient.instance().getLocalRecordCache().newInstance(OGlobalConfiguration.CACHE_LOCAL_IMPL.getValueAsString()));
    }

    @Override
    public void startup() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        this.profilerPrefix = "db." + db.getName() + ".cache.level1.";
        this.profilerMetadataPrefix = "db.*.cache.level1.";
        this.CACHE_HIT = this.profilerPrefix + "cache.found";
        this.CACHE_MISS = this.profilerPrefix + "cache.notFound";
        super.startup();
    }

    public void updateRecord(ORecord record) {
        if (record.getIdentity().getClusterId() != this.excludedCluster && record.getIdentity().isValid() && !record.isDirty() && !ORecordVersionHelper.isTombstone(record.getVersion()) && this.underlying.get(record.getIdentity()) != record) {
            this.underlying.put(record);
        }
    }

    public ORecord findRecord(ORID rid) {
        ORecord record = this.underlying.get(rid);
        if (record != null) {
            Orient.instance().getProfiler().updateCounter(this.CACHE_HIT, "Record found in Level1 Cache", 1L, "db.*.cache.level1.cache.found");
        } else {
            Orient.instance().getProfiler().updateCounter(this.CACHE_MISS, "Record not found in Level1 Cache", 1L, "db.*.cache.level1.cache.notFound");
        }
        return record;
    }

    @Override
    public void deleteRecord(ORID rid) {
        super.deleteRecord(rid);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void invalidate() {
        this.underlying.clear();
    }

    public String toString() {
        return "DB level cache records = " + this.getSize();
    }
}

