/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OSoftQueryResultList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OCommandExecutorAbstract
extends OBaseParser
implements OCommandExecutor {
    protected OProgressListener progressListener;
    protected int limit = -1;
    protected Map<Object, Object> parameters;
    protected OCommandContext context;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public OCommandExecutorAbstract init(OCommandRequestText iRequest) {
        OCommandExecutorAbstract.getDatabase().checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_READ, new Object[0]);
        this.parserText = iRequest.getText().trim();
        this.parserTextUpperCase = this.upperCase(this.parserText);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [text=" + this.parserText + "]";
    }

    public OProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public <RET extends OCommandExecutor> RET setProgressListener(OProgressListener progressListener) {
        this.progressListener = progressListener;
        return (RET)this;
    }

    public String getUndoCommand() {
        return null;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public <RET extends OCommandExecutor> RET setLimit(int iLimit) {
        this.limit = iLimit;
        return (RET)this;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getFetchPlan() {
        return null;
    }

    @Override
    public OCommandContext getContext() {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        return this.context;
    }

    @Override
    public void setContext(OCommandContext iContext) {
        this.context = iContext;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        return Collections.EMPTY_SET;
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_READ;
    }

    @Override
    public boolean involveSchema() {
        return false;
    }

    protected boolean checkInterruption() {
        return OCommandExecutorAbstract.checkInterruption(this.context);
    }

    public static boolean checkInterruption(OCommandContext iContext) {
        if (OExecutionThreadLocal.isInterruptCurrentOperation()) {
            throw new OCommandInterruptedException("The command has been interrupted");
        }
        return iContext == null || iContext.checkTimeout();
    }

    protected String upperCase(String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            String upper = ("" + c).toUpperCase(Locale.ENGLISH);
            if (upper.length() > 1) {
                result.append(c);
                continue;
            }
            result.append(upper);
        }
        return result.toString();
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
    }

    @Override
    public boolean isLocalExecution() {
        return false;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public Object mergeResults(Map<String, Object> results) throws Exception {
        if (results.isEmpty()) {
            return null;
        }
        Object aggregatedResult = null;
        for (Map.Entry<String, Object> entry : results.entrySet()) {
            Object nodeResult = entry.getValue();
            if (nodeResult instanceof Collection) {
                if (aggregatedResult == null) {
                    aggregatedResult = OSoftQueryResultList.createResultList(this.parserText);
                }
                ((List)aggregatedResult).addAll((Collection)nodeResult);
                continue;
            }
            if (nodeResult instanceof Exception) {
                throw (Exception)nodeResult;
            }
            if (nodeResult instanceof OIdentifiable) {
                if (aggregatedResult == null) {
                    aggregatedResult = OSoftQueryResultList.createResultList(this.parserText);
                }
                aggregatedResult.add(nodeResult);
                continue;
            }
            if (!(nodeResult instanceof Number)) continue;
            if (aggregatedResult == null) {
                aggregatedResult = nodeResult;
                continue;
            }
            OMultiValue.add(aggregatedResult, nodeResult);
        }
        return aggregatedResult;
    }

    public boolean isDistributedExecutingOnLocalNodeFirst() {
        return true;
    }
}

