/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.concur.resource.OPartitionedObjectPoolFactory;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class ODatabaseScriptManager {
    private final OScriptManager scriptManager;
    protected OPartitionedObjectPoolFactory<String, ScriptEngine> pooledEngines;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ODatabaseScriptManager(OScriptManager iScriptManager, String iDatabaseName) {
        this.scriptManager = iScriptManager;
        this.pooledEngines = new OPartitionedObjectPoolFactory<String, ScriptEngine>(new OPartitionedObjectPoolFactory.ObjectFactoryFactory<String, ScriptEngine>(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public OPartitionedObjectPool.ObjectFactory<ScriptEngine> create(final String language) {
                return new OPartitionedObjectPool.ObjectFactory<ScriptEngine>(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public ScriptEngine create() {
                        ScriptEngine scriptEngine = ODatabaseScriptManager.this.scriptManager.getEngine(language);
                        String library = ODatabaseScriptManager.this.scriptManager.getLibrary(ODatabaseRecordThreadLocal.instance().get(), language);
                        if (library != null) {
                            try {
                                scriptEngine.eval(library);
                            }
                            catch (ScriptException e) {
                                ODatabaseScriptManager.this.scriptManager.throwErrorMessage(e, library);
                            }
                        }
                        return scriptEngine;
                    }

                    @Override
                    public void init(ScriptEngine object) {
                    }

                    @Override
                    public void close(ScriptEngine object) {
                    }

                    @Override
                    public boolean isValid(ScriptEngine object) {
                        return !(language.equals("sql") ? !language.equals(object.getFactory().getLanguageName()) : object.getFactory().getLanguageName().equals("sql"));
                    }
                };
            }
        });
        this.pooledEngines.setMaxPoolSize(OGlobalConfiguration.SCRIPT_POOL.getValueAsInteger());
        this.pooledEngines.setMaxPartitions(1);
    }

    public OPartitionedObjectPool.PoolEntry<ScriptEngine> acquireEngine(String language) {
        return this.pooledEngines.get(language).acquire();
    }

    public void releaseEngine(String language, OPartitionedObjectPool.PoolEntry<ScriptEngine> entry) {
        this.pooledEngines.get(language).release(entry);
    }

    public void close() {
        this.pooledEngines.close();
    }
}

