/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.compression.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.compression.impl.OAbstractCompression;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.io.IOException;
import org.xerial.snappy.Snappy;

public class OSnappyCompression
extends OAbstractCompression {
    public static final String NAME = "snappy";
    public static final OSnappyCompression INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public byte[] compress(byte[] content, int offset, int length) {
        try {
            byte[] buf = new byte[Snappy.maxCompressedLength((int)length)];
            int compressedByteSize = Snappy.rawCompress((Object)content, (int)offset, (int)length, (byte[])buf, (int)0);
            byte[] result = new byte[compressedByteSize];
            System.arraycopy(buf, 0, result, 0, compressedByteSize);
            return result;
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during data compression"), e);
        }
    }

    @Override
    public byte[] uncompress(byte[] content, int offset, int length) {
        try {
            byte[] result = new byte[Snappy.uncompressedLength((byte[])content, (int)offset, (int)length)];
            int byteSize = Snappy.uncompress((byte[])content, (int)offset, (int)length, (byte[])result, (int)0);
            return result;
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during data decompression"), e);
        }
    }

    @Override
    public String name() {
        return NAME;
    }

    static {
        try {
            try {
                INSTANCE = new OSnappyCompression();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

