/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.util.OBackupable;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ODatabase<T>
extends OBackupable,
Closeable {
    public static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public <DB extends ODatabase> DB open(String var1, String var2);

    public <DB extends ODatabase> DB create();

    public <DB extends ODatabase> DB create(String var1);

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> var1);

    public ODatabase activateOnCurrentThread();

    public boolean isActiveOnCurrentThread();

    public void reload();

    public void drop();

    public OContextConfiguration getConfiguration();

    public boolean declareIntent(OIntent var1);

    public boolean exists();

    @Override
    public void close();

    public STATUS getStatus();

    @Deprecated
    public <DB extends ODatabase> DB setStatus(STATUS var1);

    public long getSize();

    public String getName();

    public String getURL();

    public OLocalRecordCache getLocalCache();

    public int getDefaultClusterId();

    public int getClusters();

    public boolean existsCluster(String var1);

    public Collection<String> getClusterNames();

    public int getClusterIdByName(String var1);

    public String getClusterNameById(int var1);

    public long getClusterRecordSizeByName(String var1);

    public long getClusterRecordSizeById(int var1);

    public boolean isClosed();

    public void truncateCluster(String var1);

    public long countClusterElements(int var1);

    public long countClusterElements(int var1, boolean var2);

    public long countClusterElements(int[] var1);

    public long countClusterElements(int[] var1, boolean var2);

    public long countClusterElements(String var1);

    public int addCluster(String var1, Object ... var2);

    public int addBlobCluster(String var1, Object ... var2);

    public Object alterCluster(String var1, OCluster.ATTRIBUTES var2, Object var3);

    public Object alterCluster(int var1, OCluster.ATTRIBUTES var2, Object var3);

    public Set<Integer> getBlobClusterIds();

    public int addCluster(String var1, int var2, Object ... var3);

    public boolean dropCluster(String var1, boolean var2);

    public boolean dropCluster(int var1, boolean var2);

    public Object setProperty(String var1, Object var2);

    public Object getProperty(String var1);

    public Iterator<Map.Entry<String, Object>> getProperties();

    public Object get(ATTRIBUTES var1);

    public <DB extends ODatabase> DB set(ATTRIBUTES var1, Object var2);

    public void registerListener(ODatabaseListener var1);

    public void unregisterListener(ODatabaseListener var1);

    @Deprecated
    public ORecordMetadata getRecordMetadata(ORID var1);

    public void freeze();

    public boolean isFrozen();

    public void release();

    public void freeze(boolean var1);

    public <RET> RET newInstance();

    public ODictionary<T> getDictionary();

    public OSecurityUser getUser();

    public <RET extends T> RET load(T var1);

    public <RET extends T> RET load(T var1, String var2);

    @Deprecated
    public <RET extends T> RET load(T var1, String var2, boolean var3, boolean var4, OStorage.LOCKING_STRATEGY var5);

    @Deprecated
    public <RET extends T> RET load(T var1, String var2, boolean var3, boolean var4, boolean var5, OStorage.LOCKING_STRATEGY var6);

    public <RET extends T> RET load(T var1, String var2, boolean var3);

    public <RET extends T> RET reload(T var1, String var2, boolean var3);

    public <RET extends T> RET reload(T var1, String var2, boolean var3, boolean var4);

    public <RET extends T> RET load(ORID var1);

    public <RET extends T> RET load(ORID var1, String var2);

    public <RET extends T> RET load(ORID var1, String var2, boolean var3);

    @Deprecated
    public <RET extends T> RET load(ORID var1, String var2, boolean var3, boolean var4, OStorage.LOCKING_STRATEGY var5);

    @Deprecated
    public <RET extends T> RET load(ORID var1, String var2, boolean var3, boolean var4, boolean var5, OStorage.LOCKING_STRATEGY var6);

    public <RET extends T> RET save(T var1);

    public <RET extends T> RET save(T var1, OPERATION_MODE var2, boolean var3, ORecordCallback<? extends Number> var4, ORecordCallback<Integer> var5);

    public <RET extends T> RET save(T var1, String var2);

    public <RET extends T> RET save(T var1, String var2, OPERATION_MODE var3, boolean var4, ORecordCallback<? extends Number> var5, ORecordCallback<Integer> var6);

    public ODatabase<T> delete(T var1);

    public ODatabase<T> delete(ORID var1);

    public ODatabase<T> delete(ORID var1, int var2);

    public boolean hide(ORID var1);

    public ODatabase<T> cleanOutRecord(ORID var1, int var2);

    public OTransaction getTransaction();

    public ODatabase<T> begin();

    public ODatabase<T> begin(OTransaction.TXTYPE var1);

    @Deprecated
    public ODatabase<T> begin(OTransaction var1) throws OTransactionException;

    public ODatabase<T> commit() throws OTransactionException;

    public ODatabase<T> commit(boolean var1) throws OTransactionException;

    public ODatabase<T> rollback() throws OTransactionException;

    public ODatabase<T> rollback(boolean var1) throws OTransactionException;

    public <RET extends List<?>> RET query(OQuery<?> var1, Object ... var2);

    public <RET extends OCommandRequest> RET command(OCommandRequest var1);

    public OMetadata getMetadata();

    public <DB extends ODatabase<?>> DB registerHook(ORecordHook var1);

    public <DB extends ODatabase<?>> DB registerHook(ORecordHook var1, ORecordHook.HOOK_POSITION var2);

    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks();

    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook var1);

    @Deprecated
    public boolean isMVCC();

    public Iterable<ODatabaseListener> getListeners();

    @Deprecated
    public <DB extends ODatabase<?>> DB setMVCC(boolean var1);

    public String getType();

    public ORecordConflictStrategy getConflictStrategy();

    public <DB extends ODatabase<?>> DB setConflictStrategy(String var1);

    public <DB extends ODatabase<?>> DB setConflictStrategy(ORecordConflictStrategy var1);

    public String incrementalBackup(String var1);

    public static final class OPERATION_MODE
    extends Enum<OPERATION_MODE> {
        public static final /* enum */ OPERATION_MODE SYNCHRONOUS;
        public static final /* enum */ OPERATION_MODE ASYNCHRONOUS;
        public static final /* enum */ OPERATION_MODE ASYNCHRONOUS_NOANSWER;
        private static final /* synthetic */ OPERATION_MODE[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static OPERATION_MODE[] values() {
            return (OPERATION_MODE[])$VALUES.clone();
        }

        public static OPERATION_MODE valueOf(String name) {
            return Enum.valueOf(OPERATION_MODE.class, name);
        }

        static {
            try {
                try {
                    SYNCHRONOUS = new OPERATION_MODE();
                    ASYNCHRONOUS = new OPERATION_MODE();
                    ASYNCHRONOUS_NOANSWER = new OPERATION_MODE();
                    $VALUES = new OPERATION_MODE[]{SYNCHRONOUS, ASYNCHRONOUS, ASYNCHRONOUS_NOANSWER};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static final class ATTRIBUTES
    extends Enum<ATTRIBUTES> {
        public static final /* enum */ ATTRIBUTES TYPE;
        public static final /* enum */ ATTRIBUTES STATUS;
        public static final /* enum */ ATTRIBUTES DEFAULTCLUSTERID;
        public static final /* enum */ ATTRIBUTES DATEFORMAT;
        public static final /* enum */ ATTRIBUTES DATETIMEFORMAT;
        public static final /* enum */ ATTRIBUTES TIMEZONE;
        public static final /* enum */ ATTRIBUTES LOCALECOUNTRY;
        public static final /* enum */ ATTRIBUTES LOCALELANGUAGE;
        public static final /* enum */ ATTRIBUTES CHARSET;
        public static final /* enum */ ATTRIBUTES CUSTOM;
        public static final /* enum */ ATTRIBUTES CLUSTERSELECTION;
        public static final /* enum */ ATTRIBUTES MINIMUMCLUSTERS;
        public static final /* enum */ ATTRIBUTES CONFLICTSTRATEGY;
        public static final /* enum */ ATTRIBUTES VALIDATION;
        private static final /* synthetic */ ATTRIBUTES[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static ATTRIBUTES[] values() {
            return (ATTRIBUTES[])$VALUES.clone();
        }

        public static ATTRIBUTES valueOf(String name) {
            return Enum.valueOf(ATTRIBUTES.class, name);
        }

        static {
            try {
                try {
                    TYPE = new ATTRIBUTES();
                    STATUS = new ATTRIBUTES();
                    DEFAULTCLUSTERID = new ATTRIBUTES();
                    DATEFORMAT = new ATTRIBUTES();
                    DATETIMEFORMAT = new ATTRIBUTES();
                    TIMEZONE = new ATTRIBUTES();
                    LOCALECOUNTRY = new ATTRIBUTES();
                    LOCALELANGUAGE = new ATTRIBUTES();
                    CHARSET = new ATTRIBUTES();
                    CUSTOM = new ATTRIBUTES();
                    CLUSTERSELECTION = new ATTRIBUTES();
                    MINIMUMCLUSTERS = new ATTRIBUTES();
                    CONFLICTSTRATEGY = new ATTRIBUTES();
                    VALIDATION = new ATTRIBUTES();
                    $VALUES = new ATTRIBUTES[]{TYPE, STATUS, DEFAULTCLUSTERID, DATEFORMAT, DATETIMEFORMAT, TIMEZONE, LOCALECOUNTRY, LOCALELANGUAGE, CHARSET, CUSTOM, CLUSTERSELECTION, MINIMUMCLUSTERS, CONFLICTSTRATEGY, VALIDATION};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static final class STATUS
    extends Enum<STATUS> {
        public static final /* enum */ STATUS OPEN;
        public static final /* enum */ STATUS CLOSED;
        public static final /* enum */ STATUS IMPORTING;
        private static final /* synthetic */ STATUS[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static STATUS[] values() {
            return (STATUS[])$VALUES.clone();
        }

        public static STATUS valueOf(String name) {
            return Enum.valueOf(STATUS.class, name);
        }

        static {
            try {
                try {
                    OPEN = new STATUS();
                    CLOSED = new STATUS();
                    IMPORTING = new STATUS();
                    $VALUES = new STATUS[]{OPEN, CLOSED, IMPORTING};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static final class OPTIONS
    extends Enum<OPTIONS> {
        public static final /* enum */ OPTIONS SECURITY;
        private static final /* synthetic */ OPTIONS[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static OPTIONS[] values() {
            return (OPTIONS[])$VALUES.clone();
        }

        public static OPTIONS valueOf(String name) {
            return Enum.valueOf(OPTIONS.class, name);
        }

        static {
            try {
                try {
                    SECURITY = new OPTIONS();
                    $VALUES = new OPTIONS[]{SECURITY};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

