/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OLazyRecordMultiIterator
implements OLazyIterator<OIdentifiable>,
OResettable {
    private final ORecord sourceRecord;
    private final Object[] underlyingSources;
    private final Object[] underlyingIterators;
    private final boolean convertToRecord;
    private int iteratorIndex = 0;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OLazyRecordMultiIterator(ORecord iSourceRecord, Object[] iIterators, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.underlyingSources = iIterators;
        this.underlyingIterators = new Object[iIterators.length];
        this.convertToRecord = iConvertToRecord;
    }

    @Override
    public void reset() {
        this.iteratorIndex = 0;
        for (int i = 0; i < this.underlyingIterators.length; ++i) {
            this.underlyingIterators[i] = null;
        }
    }

    @Override
    public OIdentifiable next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        OIdentifiable value = underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORecordId && this.convertToRecord) {
            value = ((ORecordId)value).getRecord();
            if (underlying instanceof OLazyIterator) {
                ((OLazyIterator)underlying).update(value);
            }
        }
        return value;
    }

    @Override
    public boolean hasNext() {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        boolean again = underlying.hasNext();
        while (!again && this.iteratorIndex < this.underlyingIterators.length - 1) {
            ++this.iteratorIndex;
            again = this.getCurrentIterator().hasNext();
        }
        return again;
    }

    @Override
    public OIdentifiable update(OIdentifiable iValue) {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        if (underlying instanceof OLazyIterator) {
            OIdentifiable old = ((OLazyIterator)underlying).update(iValue);
            if (this.sourceRecord != null && !old.equals(iValue)) {
                this.sourceRecord.setDirty();
            }
            return old;
        }
        throw new UnsupportedOperationException("Underlying iterator not supports lazy updates (Interface OLazyIterator");
    }

    @Override
    public void remove() {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private Iterator<OIdentifiable> getCurrentIterator() {
        if (this.iteratorIndex > this.underlyingIterators.length) {
            throw new NoSuchElementException();
        }
        Object next = this.underlyingIterators[this.iteratorIndex];
        if (next == null) {
            if (this.underlyingSources[this.iteratorIndex] instanceof OResettable) {
                ((OResettable)this.underlyingSources[this.iteratorIndex]).reset();
                this.underlyingIterators[this.iteratorIndex] = this.underlyingSources[this.iteratorIndex];
            } else if (this.underlyingSources[this.iteratorIndex] instanceof Iterable) {
                this.underlyingIterators[this.iteratorIndex] = ((Iterable)this.underlyingSources[this.iteratorIndex]).iterator();
            } else if (this.underlyingSources[this.iteratorIndex] instanceof Iterator) {
                this.underlyingIterators[this.iteratorIndex] = this.underlyingSources[this.iteratorIndex];
            } else {
                throw new IllegalStateException("Unsupported iteration source: " + this.underlyingSources[this.iteratorIndex]);
            }
            next = this.underlyingIterators[this.iteratorIndex];
        }
        if (next instanceof Iterator) {
            return (Iterator)next;
        }
        return ((Collection)next).iterator();
    }
}

