/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OPlaceholder
implements OIdentifiable,
OStreamable {
    private ORecordId rid;
    private int recordVersion;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OPlaceholder() {
    }

    public OPlaceholder(ORecordId rid, int version) {
        this.rid = rid;
        this.recordVersion = version;
    }

    public OPlaceholder(ORecord iRecord) {
        this.rid = (ORecordId)iRecord.getIdentity().copy();
        this.recordVersion = iRecord.getVersion();
    }

    @Override
    public ORID getIdentity() {
        return this.rid;
    }

    @Override
    public <T extends ORecord> T getRecord() {
        return this.rid.getRecord();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OPlaceholder)) {
            return false;
        }
        OPlaceholder other = (OPlaceholder)obj;
        return this.rid.equals(other.rid) && this.recordVersion == other.recordVersion;
    }

    public int hashCode() {
        return this.rid.hashCode() + this.recordVersion;
    }

    @Override
    public int compareTo(OIdentifiable o) {
        return this.rid.compareTo(o);
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return this.rid.compare(o1, o2);
    }

    public int getVersion() {
        return this.recordVersion;
    }

    public String toString() {
        return this.rid.toString() + " v." + this.recordVersion;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.rid.toStream(out);
        out.writeInt(this.recordVersion);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        this.rid = new ORecordId();
        this.rid.fromStream(in);
        this.recordVersion = in.readInt();
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.SHARED_LOCK);
    }

    @Override
    public boolean isLocked() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().isLockedRecord(this);
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return ODatabaseRecordThreadLocal.instance().get().getTransaction().lockingStrategy(this);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.instance().get().getTransaction().unlockRecord(this);
    }
}

