/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.exception.OAccessToSBtreeCollectionManagerIsProhibitedException;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerShared
extends OSBTreeCollectionManagerAbstract
implements OOrientStartupListener,
OOrientShutdownListener {
    private static final String PROHIBITED_EXCEPTION_MESSAGE;
    private final OAbstractPaginatedStorage storage;
    private volatile ThreadLocal<Map<UUID, OBonsaiCollectionPointer>> collectionPointerChanges = new CollectionPointerChangesThreadLocal();
    private volatile boolean prohibitAccess = false;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSBTreeCollectionManagerShared(OAbstractPaginatedStorage storage) {
        super(storage);
        this.storage = storage;
    }

    OSBTreeCollectionManagerShared(int evictionThreshold, int cacheMaxSize, OAbstractPaginatedStorage storage) {
        super(storage, evictionThreshold, cacheMaxSize);
        this.storage = storage;
    }

    @Override
    public void onShutdown() {
        this.collectionPointerChanges = null;
        super.onShutdown();
    }

    @Override
    public void onStartup() {
        super.onStartup();
        if (this.collectionPointerChanges == null) {
            this.collectionPointerChanges = new CollectionPointerChangesThreadLocal();
        }
    }

    public void prohibitAccess() {
        this.prohibitAccess = true;
    }

    private void checkAccess() {
        if (this.prohibitAccess) {
            throw new OAccessToSBtreeCollectionManagerIsProhibitedException(PROHIBITED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(int clusterId) {
        this.checkAccess();
        return super.createAndLoadTree(clusterId);
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        this.checkAccess();
        return super.loadSBTree(collectionPointer);
    }

    @Override
    public void delete(OBonsaiCollectionPointer collectionPointer) {
        this.checkAccess();
        super.delete(collectionPointer);
    }

    @Override
    public OBonsaiCollectionPointer createSBTree(int clusterId, UUID ownerUUID) {
        this.checkAccess();
        OBonsaiCollectionPointer pointer = super.createSBTree(clusterId, ownerUUID);
        if (ownerUUID != null) {
            Map<UUID, OBonsaiCollectionPointer> changedPointers = this.collectionPointerChanges.get();
            changedPointers.put(ownerUUID, pointer);
        }
        return pointer;
    }

    protected OSBTreeBonsaiLocal<OIdentifiable, Integer> createTree(int clusterId) {
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>("collections_" + clusterId, ".sbc", this.storage);
        tree.create(OLinkSerializer.INSTANCE, OIntegerSerializer.INSTANCE);
        return tree;
    }

    @Override
    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
        String fileName = atomicOperation == null ? this.storage.getWriteCache().fileNameById(collectionPointer.getFileId()) : atomicOperation.fileNameById(collectionPointer.getFileId());
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>(fileName.substring(0, fileName.length() - ".sbc".length()), ".sbc", this.storage);
        if (tree.load(collectionPointer.getRootPointer())) {
            return tree;
        }
        return null;
    }

    @Override
    public UUID listenForChanges(ORidBag collection) {
        UUID ownerUUID = collection.getTemporaryId();
        if (ownerUUID != null) {
            OBonsaiCollectionPointer pointer = collection.getPointer();
            Map<UUID, OBonsaiCollectionPointer> changedPointers = this.collectionPointerChanges.get();
            changedPointers.put(ownerUUID, pointer);
        }
        return null;
    }

    @Override
    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
    }

    @Override
    public void clearPendingCollections() {
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        return this.collectionPointerChanges.get();
    }

    @Override
    public void clearChangedIds() {
        this.collectionPointerChanges.get().clear();
    }

    static {
        try {
            try {
                PROHIBITED_EXCEPTION_MESSAGE = "Access to the manager of RidBags which are based on B-Tree implementation is prohibited. Typically it means that you use database under distributed cluster configuration. Please check that following setting in your server configuration " + OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getKey() + " is set to " + Integer.MAX_VALUE;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class CollectionPointerChangesThreadLocal
    extends ThreadLocal<Map<UUID, OBonsaiCollectionPointer>> {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private CollectionPointerChangesThreadLocal() {
        }

        @Override
        protected Map<UUID, OBonsaiCollectionPointer> initialValue() {
            return new HashMap<UUID, OBonsaiCollectionPointer>();
        }
    }
}

