/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class ODatabaseImpExpAbstract
extends ODatabaseTool {
    protected static final String DEFAULT_EXT = ".json";
    protected ODatabaseDocumentInternal database;
    protected String fileName;
    protected Set<String> includeClusters;
    protected Set<String> excludeClusters;
    protected Set<String> includeClasses;
    protected Set<String> excludeClasses;
    protected boolean includeInfo = true;
    protected boolean includeClusterDefinitions = true;
    protected boolean includeSchema = true;
    protected boolean includeSecurity = false;
    protected boolean includeRecords = true;
    protected boolean includeIndexDefinitions = true;
    protected boolean includeManualIndexes = true;
    protected boolean useLineFeedForRecords = false;
    protected boolean preserveRids = false;
    protected OCommandOutputListener listener;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ODatabaseImpExpAbstract(ODatabaseDocumentInternal iDatabase, String iFileName, OCommandOutputListener iListener) {
        this.database = iDatabase;
        this.fileName = iFileName;
        if (this.fileName != null && (this.fileName.startsWith("\"") && this.fileName.endsWith("\"") || this.fileName.startsWith("'") && this.fileName.endsWith("'"))) {
            this.fileName = this.fileName.substring(1, this.fileName.length() - 1);
            iListener.onMessage("Detected quotes surrounding filename; new backup file: " + this.fileName);
        }
        if (this.fileName != null && this.fileName.indexOf(46) == -1) {
            this.fileName = this.fileName + DEFAULT_EXT;
        }
        this.listener = iListener;
        this.excludeClusters = new LinkedHashSet<String>();
        this.excludeClusters.add("index");
        this.excludeClusters.add("manindex");
    }

    public Set<String> getIncludeClusters() {
        return this.includeClusters;
    }

    public void setIncludeClusters(Set<String> includeClusters) {
        this.includeClusters = includeClusters;
    }

    public Set<String> getExcludeClusters() {
        return this.excludeClusters;
    }

    public void setExcludeClusters(Set<String> excludeClusters) {
        this.excludeClusters = excludeClusters;
    }

    public Set<String> getIncludeClasses() {
        return this.includeClasses;
    }

    public void setIncludeClasses(Set<String> includeClasses) {
        this.includeClasses = includeClasses;
    }

    public Set<String> getExcludeClasses() {
        return this.excludeClasses;
    }

    public void setExcludeClasses(Set<String> excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    public OCommandOutputListener getListener() {
        return this.listener;
    }

    public void setListener(OCommandOutputListener listener) {
        this.listener = listener;
    }

    public ODatabaseDocument getDatabase() {
        return this.database;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isIncludeInfo() {
        return this.includeInfo;
    }

    public void setIncludeInfo(boolean includeInfo) {
        this.includeInfo = includeInfo;
    }

    public boolean isIncludeSecurity() {
        return this.includeSecurity;
    }

    public void setIncludeSecurity(boolean includeSecurity) {
        this.includeSecurity = includeSecurity;
    }

    public boolean isIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean isIncludeRecords() {
        return this.includeRecords;
    }

    public void setIncludeRecords(boolean includeRecords) {
        this.includeRecords = includeRecords;
    }

    public boolean isIncludeIndexDefinitions() {
        return this.includeIndexDefinitions;
    }

    public void setIncludeIndexDefinitions(boolean includeIndexDefinitions) {
        this.includeIndexDefinitions = includeIndexDefinitions;
    }

    public boolean isIncludeManualIndexes() {
        return this.includeManualIndexes;
    }

    public void setIncludeManualIndexes(boolean includeManualIndexes) {
        this.includeManualIndexes = includeManualIndexes;
    }

    public boolean isIncludeClusterDefinitions() {
        return this.includeClusterDefinitions;
    }

    public void setIncludeClusterDefinitions(boolean includeClusterDefinitions) {
        this.includeClusterDefinitions = includeClusterDefinitions;
    }

    public boolean isUseLineFeedForRecords() {
        return this.useLineFeedForRecords;
    }

    public void setUseLineFeedForRecords(boolean useLineFeedForRecords) {
        this.useLineFeedForRecords = useLineFeedForRecords;
    }

    public boolean isPreserveRids() {
        return this.preserveRids;
    }

    public void setPreserveRids(boolean preserveRids) {
        this.preserveRids = preserveRids;
    }

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-excludeAll")) {
            this.includeInfo = false;
            this.includeClusterDefinitions = false;
            this.includeSchema = false;
            this.includeSecurity = false;
            this.includeRecords = false;
            this.includeIndexDefinitions = false;
            this.includeManualIndexes = false;
        } else if (option.equalsIgnoreCase("-includeClass")) {
            this.includeClasses = new HashSet<String>();
            for (String item : items) {
                this.includeClasses.add(item.toUpperCase(Locale.ENGLISH));
            }
            this.includeRecords = true;
        } else if (option.equalsIgnoreCase("-excludeClass")) {
            this.excludeClasses = new HashSet<String>(items);
            for (String item : items) {
                this.excludeClasses.add(item.toUpperCase(Locale.ENGLISH));
            }
        } else if (option.equalsIgnoreCase("-includeCluster")) {
            this.includeClusters = new HashSet<String>(items);
            for (String item : items) {
                this.includeClusters.add(item.toUpperCase(Locale.ENGLISH));
            }
            this.includeRecords = true;
        } else if (option.equalsIgnoreCase("-excludeCluster")) {
            this.excludeClusters = new HashSet<String>(items);
            for (String item : items) {
                this.excludeClusters.add(item.toUpperCase(Locale.ENGLISH));
            }
        } else if (option.equalsIgnoreCase("-includeInfo")) {
            this.includeInfo = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-includeClusterDefinitions")) {
            this.includeClusterDefinitions = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-includeSchema")) {
            this.includeSchema = Boolean.parseBoolean(items.get(0));
            if (this.includeSchema) {
                this.includeClusterDefinitions = true;
                this.includeInfo = true;
            }
        } else if (option.equalsIgnoreCase("-includeSecurity")) {
            this.includeSecurity = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-includeRecords")) {
            this.includeRecords = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-includeIndexDefinitions")) {
            this.includeIndexDefinitions = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-includeManualIndexes")) {
            this.includeManualIndexes = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-useLineFeedForRecords")) {
            this.useLineFeedForRecords = Boolean.parseBoolean(items.get(0));
        }
    }
}

