/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.dictionary;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class ODictionary<T> {
    private OIndex<OIdentifiable> index;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ODictionary(OIndex<OIdentifiable> iIndex) {
        this.index = iIndex;
    }

    public <RET extends T> RET get(String iKey) {
        OIdentifiable value = this.index.get(iKey);
        if (value == null) {
            return null;
        }
        return (RET)value.getRecord();
    }

    public <RET extends T> RET get(String iKey, String iFetchPlan) {
        OIdentifiable value = this.index.get(iKey);
        if (value == null) {
            return null;
        }
        if (value instanceof ORID) {
            return ODatabaseRecordThreadLocal.instance().get().load((ORID)value, iFetchPlan);
        }
        return (RET)((ODocument)value).load(iFetchPlan);
    }

    public void put(String iKey, Object iValue) {
        this.index.put(iKey, (OIdentifiable)iValue);
    }

    public boolean containsKey(String iKey) {
        return this.index.contains(iKey);
    }

    public boolean remove(String iKey) {
        return this.index.remove(iKey);
    }

    public long size() {
        return this.index.getSize();
    }

    public OIndex<OIdentifiable> getIndex() {
        return this.index;
    }
}

