/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.entity;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.entity.OEntityManagerClassHandler;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OEntityManager {
    private static Map<String, OEntityManager> databaseInstances;
    private OEntityManagerClassHandler classHandler = new OEntityManagerClassHandler();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    protected OEntityManager() {
        OLogManager.instance().debug((Object)this, "Registering entity manager", new Object[0]);
        this.classHandler.registerEntityClass(OUser.class);
        this.classHandler.registerEntityClass(ORole.class);
    }

    public static synchronized OEntityManager getEntityManagerByDatabaseURL(String iURL) {
        OEntityManager instance = databaseInstances.get(iURL);
        if (instance == null) {
            instance = new OEntityManager();
            databaseInstances.put(iURL, instance);
        }
        return instance;
    }

    public synchronized Object createPojo(String iClassName) throws OConfigurationException {
        if (iClassName == null) {
            throw new IllegalArgumentException("Cannot create the object: class name is empty");
        }
        Class<?> entityClass = this.classHandler.getEntityClass(iClassName);
        try {
            if (entityClass != null) {
                return this.createInstance(entityClass);
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OConfigurationException("Error while creating new pojo of class '" + iClassName + "'"), e);
        }
        try {
            return this.createInstance(Class.forName(iClassName));
        }
        catch (Exception e) {
            throw OException.wrapException(new OConfigurationException("The class '" + iClassName + "' was not found between the entity classes. Ensure registerEntityClasses(package) has been called first"), e);
        }
    }

    public synchronized Class<?> getEntityClass(String iClassName) {
        return this.classHandler.getEntityClass(iClassName);
    }

    public synchronized void deregisterEntityClass(Class<?> iClass) {
        this.classHandler.deregisterEntityClass(iClass);
    }

    public synchronized void deregisterEntityClasses(String iPackageName) {
        this.deregisterEntityClasses(iPackageName, Thread.currentThread().getContextClassLoader());
    }

    public synchronized void deregisterEntityClasses(String iPackageName, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Discovering entity classes inside package: %s", iPackageName);
        List<Class<?>> classes = null;
        try {
            classes = OReflectionHelper.getClassesFor(iPackageName, iClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException(new ODatabaseException("Class cannot be found in package " + iPackageName), e);
        }
        for (Class<?> clazz : classes) {
            this.deregisterEntityClass(clazz);
        }
        if (OLogManager.instance().isDebugEnabled()) {
            for (Map.Entry entry : this.classHandler.getClassesEntrySet()) {
                OLogManager.instance().debug((Object)this, "Unloaded entity class '%s' from: %s", entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void registerEntityClass(Class<?> iClass) {
        this.registerEntityClass(iClass, true);
    }

    public synchronized void registerEntityClass(Class<?> iClass, boolean forceSchemaReload) {
        this.classHandler.registerEntityClass(iClass, forceSchemaReload);
    }

    public synchronized void registerEntityClasses(Collection<String> iClassNames) {
        this.registerEntityClasses(iClassNames, Thread.currentThread().getContextClassLoader());
    }

    public synchronized void registerEntityClasses(Collection<String> iClassNames, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Discovering entity classes for class names: %s", iClassNames);
        try {
            this.registerEntityClasses(OReflectionHelper.getClassesFor(iClassNames, iClassLoader));
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException(new ODatabaseException("Entity class cannot be found"), e);
        }
    }

    public synchronized void registerEntityClasses(String iPackageName) {
        this.registerEntityClasses(iPackageName, Thread.currentThread().getContextClassLoader());
    }

    public synchronized void registerEntityClasses(String iPackageName, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Discovering entity classes inside package: %s", iPackageName);
        try {
            this.registerEntityClasses(OReflectionHelper.getClassesFor(iPackageName, iClassLoader));
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException(new ODatabaseException("Entity class cannot be found"), e);
        }
    }

    protected synchronized void registerEntityClasses(List<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            if (this.classHandler.containsEntityClass(clazz)) continue;
            if (clazz.isAnonymousClass()) {
                OLogManager.instance().debug((Object)this, "Skip registration of anonymous class '%s'", clazz.getName());
                continue;
            }
            this.classHandler.registerEntityClass(clazz);
        }
        if (OLogManager.instance().isDebugEnabled()) {
            for (Map.Entry entry : this.classHandler.getClassesEntrySet()) {
                OLogManager.instance().debug((Object)this, "Loaded entity class '%s' from: %s", entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void registerEntityClasses(Class<?> aClass, boolean recursive) {
        if (recursive) {
            Field[] declaredFields;
            this.classHandler.registerEntityClass(aClass);
            for (Field declaredField : declaredFields = aClass.getDeclaredFields()) {
                Class<?> declaredFieldType = declaredField.getType();
                if (this.classHandler.containsEntityClass(declaredFieldType)) continue;
                this.registerEntityClasses(declaredFieldType, recursive);
            }
        } else {
            this.classHandler.registerEntityClass(aClass);
        }
    }

    public synchronized void setClassHandler(OEntityManagerClassHandler iClassHandler) {
        Iterator<Map.Entry<String, Class<?>>> iterator = this.classHandler.getClassesEntrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Class<?>> entry = iterator.next();
            boolean forceSchemaReload = !iterator.hasNext();
            iClassHandler.registerEntityClass(entry.getValue(), forceSchemaReload);
        }
        this.classHandler = iClassHandler;
    }

    public synchronized Collection<Class<?>> getRegisteredEntities() {
        return this.classHandler.getRegisteredEntities();
    }

    protected Object createInstance(Class<?> iClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.classHandler.createInstance(iClass);
    }

    static {
        try {
            try {
                databaseInstances = new HashMap<String, OEntityManager>();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

