/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_SEPARATOR_CHARS = "separatorChars";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static final String CONFIG_INDEX_RADIX = "indexRadix";
    private static final String CONFIG_MIN_WORD_LEN = "minWordLength";
    private static final boolean DEF_INDEX_RADIX = true;
    private static final String DEF_SEPARATOR_CHARS = " \r\n\t:;,.|+*/\\=!?[]()";
    private static final String DEF_IGNORE_CHARS = "'\"";
    private static final String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was were is";
    private static int DEF_MIN_WORD_LENGTH;
    private boolean indexRadix;
    private String separatorChars;
    private String ignoreChars;
    private int minWordLength;
    private Set<String> stopWords;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexFullText(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata);
        this.acquireExclusiveLock();
        try {
            this.config();
            this.configWithMetadata(metadata);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object key, final OIdentifiable singleValue) {
        if (key == null) {
            return this;
        }
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            Set<String> words = this.splitIntoWords(key.toString());
            block10: for (String word : words) {
                this.acquireSharedLock();
                try {
                    Set refs;
                    while (true) {
                        try {
                            refs = (Set)this.storage.getIndexValue(this.indexId, word);
                        }
                        catch (OInvalidIndexEngineIdException ignore) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                    final boolean durable = this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"));
                    final Set refsc = refs;
                    while (true) {
                        try {
                            this.storage.updateIndexEntry(this.indexId, word, new Callable<Object>(){
                                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Override
                                public Object call() throws Exception {
                                    Set result = null;
                                    if (refsc == null) {
                                        if (!"SBTREEBONSAISET".equals(OIndexFullText.this.valueContainerAlgorithm)) throw new IllegalStateException("MBRBTreeContainer is not supported any more");
                                        result = new OIndexRIDContainer(OIndexFullText.this.getName(), durable);
                                    } else {
                                        result = refsc;
                                    }
                                    result.add(singleValue);
                                    return result;
                                }
                            });
                            continue block10;
                        }
                        catch (OInvalidIndexEngineIdException ignore) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            OIndexFullText oIndexFullText = this;
            return oIndexFullText;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        if (key == null) {
            return false;
        }
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            Set<String> words = this.splitIntoWords(key.toString());
            OModifiableBoolean removed = new OModifiableBoolean(false);
            block10: for (String word : words) {
                this.acquireSharedLock();
                try {
                    Set recs;
                    while (true) {
                        try {
                            recs = (Set)this.storage.getIndexValue(this.indexId, word);
                        }
                        catch (OInvalidIndexEngineIdException ignore) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                    if (recs == null || recs.isEmpty()) continue;
                    while (true) {
                        try {
                            this.storage.updateIndexEntry(this.indexId, word, new EntityRemover(recs, value, removed));
                            continue block10;
                        }
                        catch (OInvalidIndexEngineIdException ignore) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            boolean bl = removed.getValue();
            return bl;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    @Override
    public OIndexInternal<?> create(OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OBinarySerializer valueSerializer) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, valueSerializer);
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, (Set)clustersToIndex, rebuild, progressListener);
    }

    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        return ((FullTextIndexConfiguration)this.configuration).updateFullTextIndexConfiguration(this.separatorChars, this.ignoreChars, this.stopWords, this.minWordLength, this.indexRadix);
    }

    @Override
    protected OIndexAbstract.IndexConfiguration indexConfigurationInstance(ODocument document) {
        return new FullTextIndexConfiguration(document);
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    protected void configWithMetadata(ODocument metadata) {
        if (metadata != null) {
            if (metadata.containsField(CONFIG_IGNORE_CHARS)) {
                this.ignoreChars = (String)metadata.field(CONFIG_IGNORE_CHARS);
            }
            if (metadata.containsField(CONFIG_INDEX_RADIX)) {
                this.indexRadix = (Boolean)metadata.field(CONFIG_INDEX_RADIX);
            }
            if (metadata.containsField(CONFIG_SEPARATOR_CHARS)) {
                this.separatorChars = (String)metadata.field(CONFIG_SEPARATOR_CHARS);
            }
            if (metadata.containsField(CONFIG_MIN_WORD_LEN)) {
                this.minWordLength = (Integer)metadata.field(CONFIG_MIN_WORD_LEN);
            }
            if (metadata.containsField(CONFIG_STOP_WORDS)) {
                this.stopWords = new HashSet<String>((Collection)metadata.field(CONFIG_STOP_WORDS));
            }
        }
    }

    protected void config() {
        this.ignoreChars = DEF_IGNORE_CHARS;
        this.indexRadix = true;
        this.separatorChars = DEF_SEPARATOR_CHARS;
        this.minWordLength = DEF_MIN_WORD_LENGTH;
        this.stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));
    }

    private Set<String> splitIntoWords(String iKey) {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> words = new ArrayList<String>();
        OStringSerializerHelper.split(words, iKey, 0, -1, this.separatorChars, new char[0]);
        StringBuilder buffer = new StringBuilder(64);
        block0: for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            for (int length = buffer.length(); length >= this.minWordLength; --length) {
                buffer.setLength(length);
                word = buffer.toString();
                if (!this.stopWords.contains(word)) {
                    result.add(word);
                }
                if (!this.indexRadix) continue block0;
            }
        }
        return result;
    }

    static {
        try {
            try {
                DEF_MIN_WORD_LENGTH = 3;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private final class FullTextIndexConfiguration
    extends OIndexAbstract.IndexConfiguration {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public FullTextIndexConfiguration(ODocument document) {
            super(document);
        }

        public synchronized ODocument updateFullTextIndexConfiguration(String separatorChars, String ignoreChars, Set<String> stopWords, int minWordLength, boolean indexRadix) {
            this.document.field(OIndexFullText.CONFIG_SEPARATOR_CHARS, separatorChars);
            this.document.field(OIndexFullText.CONFIG_IGNORE_CHARS, ignoreChars);
            this.document.field(OIndexFullText.CONFIG_STOP_WORDS, stopWords);
            this.document.field(OIndexFullText.CONFIG_MIN_WORD_LEN, minWordLength);
            this.document.field(OIndexFullText.CONFIG_INDEX_RADIX, indexRadix);
            return this.document;
        }
    }

    private static class EntityRemover
    implements Callable<Object> {
        private final Set<OIdentifiable> recs;
        private final OIdentifiable value;
        private final OModifiableBoolean removed;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public EntityRemover(Set<OIdentifiable> recs, OIdentifiable value, OModifiableBoolean removed) {
            this.recs = recs;
            this.value = value;
            this.removed = removed;
        }

        @Override
        public Object call() throws Exception {
            if (this.recs.remove(this.value)) {
                this.removed.setValue(true);
                if (this.recs.isEmpty()) {
                    return null;
                }
                return this.recs;
            }
            return this.recs;
        }
    }
}

