/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractDelegate;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.Map;

public abstract class OIndexTxAware<T>
extends OIndexAbstractDelegate<T> {
    private static final OAlwaysLessKey ALWAYS_LESS_KEY;
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY;
    protected ODatabaseDocumentInternal database;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OIndexTxAware(ODatabaseDocumentInternal iDatabase, OIndex<T> iDelegate) {
        super(iDelegate);
        this.database = iDatabase;
    }

    @Override
    public long getSize() {
        long tot = this.delegate.getSize();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges != null) {
            if (indexChanges.cleared) {
                tot = 0L;
            }
            for (Map.Entry entry : indexChanges.changesPerKey.entrySet()) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : ((OTransactionIndexChangesPerKey)entry.getValue()).entries) {
                    if (e.operation != OTransactionIndexChanges.OPERATION.REMOVE || e.value != null) continue;
                    --tot;
                }
            }
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : indexChanges.nullKeyChanges.entries) {
                if (e.operation != OTransactionIndexChanges.OPERATION.REMOVE || e.value != null) continue;
                --tot;
            }
        }
        return tot;
    }

    @Override
    public OIndexTxAware<T> put(Object iKey, OIdentifiable iValue) {
        this.checkForKeyType(iKey);
        ORID rid = iValue.getIdentity();
        if (!rid.isValid()) {
            if (iValue instanceof ORecord) {
                ((ORecord)iValue).save();
            } else {
                throw new IllegalArgumentException("Cannot store non persistent RID as index value for key '" + iKey + "'");
            }
        }
        iKey = this.getCollatingValue(iKey);
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, iKey, iValue);
        return this;
    }

    public OIndexTxAware<T> putOnlyClientTrack(Object iKey, OIdentifiable iValue) {
        ORID rid = iValue.getIdentity();
        if (!rid.isValid()) {
            if (iValue instanceof ORecord) {
                ((ORecord)iValue).save();
            } else {
                throw new IllegalArgumentException("Cannot store non persistent RID as index value for key '" + iKey + "'");
            }
        }
        iKey = this.getCollatingValue(iKey);
        ((OTransactionRealAbstract)this.database.getTransaction()).addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, iKey, iValue, true);
        return this;
    }

    @Override
    public boolean remove(Object key) {
        key = this.getCollatingValue(key);
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, key, null);
        return true;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        iKey = this.getCollatingValue(iKey);
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, iRID);
        return true;
    }

    public boolean removeOnlyClientTrack(Object iKey, OIdentifiable iRID) {
        iKey = this.getCollatingValue(iKey);
        ((OTransactionRealAbstract)this.database.getTransaction()).addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, iRID, true);
        return true;
    }

    @Override
    public OIndexTxAware<T> clear() {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.CLEAR, null, null);
        return this;
    }

    @Override
    public Object getFirstKey() {
        OTransactionIndexChangesPerKey changesPerKey;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return this.delegate.getFirstKey();
        }
        Object indexFirstKey = indexChanges.cleared ? null : this.delegate.getFirstKey();
        Object firstKey = indexChanges.getFirstKey();
        do {
            changesPerKey = indexChanges.getChangesPerKey(firstKey);
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
                if (indexEntry.operation.equals((Object)OTransactionIndexChanges.OPERATION.REMOVE)) {
                    firstKey = null;
                    continue;
                }
                firstKey = changesPerKey.key;
            }
            if (changesPerKey.key.equals(indexFirstKey)) {
                indexFirstKey = firstKey;
            }
            if (firstKey == null) continue;
            if (indexFirstKey != null && ((Comparable)indexFirstKey).compareTo(firstKey) < 0) {
                return indexFirstKey;
            }
            return firstKey;
        } while ((firstKey = indexChanges.getHigherKey(changesPerKey.key)) != null);
        return indexFirstKey;
    }

    @Override
    public Object getLastKey() {
        OTransactionIndexChangesPerKey changesPerKey;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return this.delegate.getLastKey();
        }
        Object indexLastKey = indexChanges.cleared ? null : this.delegate.getLastKey();
        Object lastKey = indexChanges.getLastKey();
        do {
            changesPerKey = indexChanges.getChangesPerKey(lastKey);
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
                if (indexEntry.operation.equals((Object)OTransactionIndexChanges.OPERATION.REMOVE)) {
                    lastKey = null;
                    continue;
                }
                lastKey = changesPerKey.key;
            }
            if (changesPerKey.key.equals(indexLastKey)) {
                indexLastKey = lastKey;
            }
            if (lastKey == null) continue;
            if (indexLastKey != null && ((Comparable)indexLastKey).compareTo(lastKey) > 0) {
                return indexLastKey;
            }
            return lastKey;
        } while ((lastKey = indexChanges.getLowerKey(changesPerKey.key)) != null);
        return indexLastKey;
    }

    protected Object enhanceCompositeKey(Object key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        int keySize = this.getDefinition().getParamCount();
        if (keySize != 1 && compositeKey.getKeys().size() != keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return fullKey;
        }
        return key;
    }

    protected Object enhanceToCompositeKeyBetweenAsc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenAsc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    protected Object enhanceToCompositeKeyBetweenDesc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenDesc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    protected Object getCollatingValue(Object key) {
        OIndexDefinition definition = this.getDefinition();
        if (key != null && definition != null) {
            return definition.getCollate().transform(key);
        }
        return key;
    }

    static {
        try {
            try {
                ALWAYS_LESS_KEY = new OAlwaysLessKey();
                ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    public static final class PartialSearchMode
    extends Enum<PartialSearchMode> {
        public static final /* enum */ PartialSearchMode NONE;
        public static final /* enum */ PartialSearchMode HIGHEST_BOUNDARY;
        public static final /* enum */ PartialSearchMode LOWEST_BOUNDARY;
        private static final /* synthetic */ PartialSearchMode[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static PartialSearchMode[] values() {
            return (PartialSearchMode[])$VALUES.clone();
        }

        public static PartialSearchMode valueOf(String name) {
            return Enum.valueOf(PartialSearchMode.class, name);
        }

        static {
            try {
                try {
                    NONE = new PartialSearchMode();
                    HIGHEST_BOUNDARY = new PartialSearchMode();
                    LOWEST_BOUNDARY = new PartialSearchMode();
                    $VALUES = new PartialSearchMode[]{NONE, HIGHEST_BOUNDARY, LOWEST_BOUNDARY};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

