/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OIndexTxAwareMultiValue
extends OIndexTxAware<Set<OIdentifiable>> {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OIndexTxAwareMultiValue(ODatabaseDocumentInternal database, OIndex<Set<OIdentifiable>> delegate) {
        super(database, delegate);
    }

    @Override
    public Set<OIdentifiable> get(Object key) {
        Collection subResult;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return (Set)super.get(key);
        }
        key = this.getCollatingValue(key);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        if (!indexChanges.cleared && (subResult = (Collection)super.get(key)) != null) {
            for (OIdentifiable oid : subResult) {
                result.add(oid);
            }
        }
        HashSet<OIdentifiable> processed = new HashSet<OIdentifiable>();
        for (OIdentifiable identifiable : result) {
            Map.Entry<Object, OIdentifiable> entry = this.calculateTxIndexEntry(key, identifiable, indexChanges);
            if (entry == null) continue;
            processed.add(entry.getValue());
        }
        Set<OIdentifiable> txChanges = this.calculateTxValue(key, indexChanges);
        if (txChanges != null) {
            processed.addAll(txChanges);
        }
        if (!processed.isEmpty()) {
            return processed;
        }
        return null;
    }

    @Override
    public boolean contains(Object key) {
        Object result = this.get(key);
        return result != null && !result.isEmpty();
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(fromKey, fromInclusive, toKey, toInclusive, indexChanges) : new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, toKey, toInclusive, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
        }
        fromKey = this.getCollatingValue(fromKey);
        Object lastKey = indexChanges.getLastKey();
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(fromKey, fromInclusive, lastKey, true, indexChanges) : new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, lastKey, true, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesMinor(toKey, toInclusive, ascOrder);
        }
        toKey = this.getCollatingValue(toKey);
        Object firstKey = indexChanges.getFirstKey();
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(firstKey, true, toKey, toInclusive, indexChanges) : new PureTxBetweenIndexBackwardCursor(firstKey, true, toKey, toInclusive, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesMinor(toKey, toInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntries(keys, ascSortOrder);
        }
        final ArrayList<Object> sortedKeys = new ArrayList<Object>(keys.size());
        for (Object key : keys) {
            sortedKeys.add(this.getCollatingValue(key));
        }
        if (ascSortOrder) {
            Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        } else {
            Collections.sort(sortedKeys, Collections.reverseOrder(ODefaultComparator.INSTANCE));
        }
        OIndexAbstractCursor txCursor = new OIndexAbstractCursor(){
            private Iterator<Object> keysIterator;
            private Iterator<OIdentifiable> valuesIterator;
            private Object key;
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
            {
                this.keysIterator = sortedKeys.iterator();
                this.valuesIterator = new OEmptyIterator<OIdentifiable>();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.valuesIterator.hasNext()) {
                    return this.nextEntryInternal();
                }
                if (this.keysIterator == null) {
                    return null;
                }
                Set result = null;
                while (result == null && this.keysIterator.hasNext()) {
                    this.key = this.keysIterator.next();
                    result = OIndexTxAwareMultiValue.this.calculateTxValue(this.key, indexChanges);
                    if (result == null || !result.isEmpty()) continue;
                    result = null;
                }
                if (result == null) {
                    this.keysIterator = null;
                    return null;
                }
                this.valuesIterator = result.iterator();
                return this.nextEntryInternal();
            }

            private Map.Entry<Object, OIdentifiable> nextEntryInternal() {
                final OIdentifiable identifiable = this.valuesIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public Object getKey() {
                        return key;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntries(keys, ascSortOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascSortOrder, indexChanges);
    }

    private Map.Entry<Object, OIdentifiable> calculateTxIndexEntry(Object key, OIdentifiable backendValue, OTransactionIndexChanges indexChanges) {
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            return this.createMapEntry(key, backendValue);
        }
        int putCounter = 1;
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.PUT && entry.value.equals(backendValue)) {
                ++putCounter;
                continue;
            }
            if (entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
            if (entry.value == null) {
                putCounter = 0;
                continue;
            }
            if (!entry.value.equals(backendValue) || putCounter <= 0) continue;
            --putCounter;
        }
        if (putCounter <= 0) {
            return null;
        }
        return this.createMapEntry(key, backendValue);
    }

    private Map.Entry<Object, OIdentifiable> createMapEntry(Object key, OIdentifiable backendValue) {
        return new MapEntry(key, backendValue);
    }

    private Set<OIdentifiable> calculateTxValue(Object key, OTransactionIndexChanges indexChanges) {
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            return null;
        }
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                if (entry.value == null) {
                    result.clear();
                    continue;
                }
                result.remove(entry.value);
                continue;
            }
            result.add(entry.value);
        }
        if (result.isEmpty()) {
            return null;
        }
        return new HashSet<OIdentifiable>(result);
    }

    private class OIndexTxCursor
    extends OIndexAbstractCursor {
        private final OIndexCursor backedCursor;
        private final boolean ascOrder;
        private final OTransactionIndexChanges indexChanges;
        private OIndexCursor txBetweenIndexCursor;
        private Map.Entry<Object, OIdentifiable> nextTxEntry;
        private Map.Entry<Object, OIdentifiable> nextBackedEntry;
        private boolean firstTime;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public OIndexTxCursor(OIndexCursor txCursor, OIndexCursor backedCursor, boolean ascOrder, OTransactionIndexChanges indexChanges) {
            this.backedCursor = backedCursor;
            this.ascOrder = ascOrder;
            this.indexChanges = indexChanges;
            this.txBetweenIndexCursor = txCursor;
            this.firstTime = true;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.firstTime) {
                this.nextTxEntry = this.txBetweenIndexCursor.nextEntry();
                this.nextBackedEntry = this.backedCursor.nextEntry();
                this.firstTime = false;
            }
            Map.Entry<Object, OIdentifiable> result = null;
            while (result == null && (this.nextTxEntry != null || this.nextBackedEntry != null)) {
                if (this.nextTxEntry == null && this.nextBackedEntry != null) {
                    result = this.nextBackedEntry(this.getPrefetchSize());
                    continue;
                }
                if (this.nextBackedEntry == null && this.nextTxEntry != null) {
                    result = this.nextTxEntry(this.getPrefetchSize());
                    continue;
                }
                if (this.nextTxEntry == null || this.nextBackedEntry == null) continue;
                if (this.ascOrder) {
                    if (ODefaultComparator.INSTANCE.compare(this.nextBackedEntry.getKey(), this.nextTxEntry.getKey()) <= 0) {
                        result = this.nextBackedEntry(this.getPrefetchSize());
                        continue;
                    }
                    result = this.nextTxEntry(this.getPrefetchSize());
                    continue;
                }
                if (ODefaultComparator.INSTANCE.compare(this.nextBackedEntry.getKey(), this.nextTxEntry.getKey()) >= 0) {
                    result = this.nextBackedEntry(this.getPrefetchSize());
                    continue;
                }
                result = this.nextTxEntry(this.getPrefetchSize());
            }
            return result;
        }

        private Map.Entry<Object, OIdentifiable> nextTxEntry(int prefetchSize) {
            Map.Entry<Object, OIdentifiable> result = this.nextTxEntry;
            this.nextTxEntry = this.txBetweenIndexCursor.nextEntry();
            return result;
        }

        private Map.Entry<Object, OIdentifiable> nextBackedEntry(int prefetchSize) {
            Map.Entry result = OIndexTxAwareMultiValue.this.calculateTxIndexEntry(this.nextBackedEntry.getKey(), this.nextBackedEntry.getValue(), this.indexChanges);
            this.nextBackedEntry = this.backedCursor.nextEntry();
            return result;
        }
    }

    private class PureTxBetweenIndexBackwardCursor
    extends OIndexAbstractCursor {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object lastKey;
        private Object nextKey;
        private Iterator<OIdentifiable> valuesIterator = new OEmptyIterator<OIdentifiable>();
        private Object key;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public PureTxBetweenIndexBackwardCursor(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            this.indexChanges = indexChanges;
            fromKey = OIndexTxAwareMultiValue.this.enhanceFromCompositeKeyBetweenDesc(fromKey, fromInclusive);
            toKey = OIndexTxAwareMultiValue.this.enhanceToCompositeKeyBetweenDesc(toKey, toInclusive);
            this.firstKey = fromInclusive ? indexChanges.getCeilingKey(fromKey) : indexChanges.getHigherKey(fromKey);
            this.lastKey = toInclusive ? indexChanges.getFloorKey(toKey) : indexChanges.getLowerKey(toKey);
            this.nextKey = this.lastKey;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            Set result;
            if (this.valuesIterator.hasNext()) {
                return this.nextEntryInternal();
            }
            if (this.nextKey == null) {
                return null;
            }
            do {
                result = OIndexTxAwareMultiValue.this.calculateTxValue(this.nextKey, this.indexChanges);
                this.key = this.nextKey;
                this.nextKey = this.indexChanges.getLowerKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.firstKey) >= 0) continue;
                this.nextKey = null;
            } while ((result == null || result.isEmpty()) && this.nextKey != null);
            if (result == null || result.isEmpty()) {
                return null;
            }
            this.valuesIterator = result.iterator();
            return this.nextEntryInternal();
        }

        private Map.Entry<Object, OIdentifiable> nextEntryInternal() {
            final OIdentifiable identifiable = this.valuesIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){
                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                @Override
                public Object getKey() {
                    return PureTxBetweenIndexBackwardCursor.this.key;
                }

                @Override
                public OIdentifiable getValue() {
                    return identifiable;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }

    private class PureTxBetweenIndexForwardCursor
    extends OIndexAbstractCursor {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object lastKey;
        private Object nextKey;
        private Iterator<OIdentifiable> valuesIterator = new OEmptyIterator<OIdentifiable>();
        private Object key;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public PureTxBetweenIndexForwardCursor(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            this.indexChanges = indexChanges;
            fromKey = OIndexTxAwareMultiValue.this.enhanceFromCompositeKeyBetweenAsc(fromKey, fromInclusive);
            toKey = OIndexTxAwareMultiValue.this.enhanceToCompositeKeyBetweenAsc(toKey, toInclusive);
            this.firstKey = fromInclusive ? indexChanges.getCeilingKey(fromKey) : indexChanges.getHigherKey(fromKey);
            this.lastKey = toInclusive ? indexChanges.getFloorKey(toKey) : indexChanges.getLowerKey(toKey);
            this.nextKey = this.firstKey;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            Set result;
            if (this.valuesIterator.hasNext()) {
                return this.nextEntryInternal();
            }
            if (this.nextKey == null) {
                return null;
            }
            do {
                result = OIndexTxAwareMultiValue.this.calculateTxValue(this.nextKey, this.indexChanges);
                this.key = this.nextKey;
                this.nextKey = this.indexChanges.getHigherKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.lastKey) <= 0) continue;
                this.nextKey = null;
            } while ((result == null || result.isEmpty()) && this.nextKey != null);
            if (result == null || result.isEmpty()) {
                return null;
            }
            this.valuesIterator = result.iterator();
            return this.nextEntryInternal();
        }

        Map.Entry<Object, OIdentifiable> nextEntryInternal() {
            final OIdentifiable identifiable = this.valuesIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){
                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                @Override
                public Object getKey() {
                    return PureTxBetweenIndexForwardCursor.this.key;
                }

                @Override
                public OIdentifiable getValue() {
                    return identifiable;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }

    private static class MapEntry
    implements Map.Entry<Object, OIdentifiable> {
        private final Object key;
        private final OIdentifiable backendValue;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public MapEntry(Object key, OIdentifiable backendValue) {
            this.key = key;
            this.backendValue = backendValue;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public OIdentifiable getValue() {
            return this.backendValue;
        }

        @Override
        public OIdentifiable setValue(OIdentifiable value) {
            throw new UnsupportedOperationException("setValue");
        }
    }
}

