/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtree.local;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.IOException;

public class ONullBucket<V>
extends ODurablePage {
    private final OBinarySerializer<V> valueSerializer;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ONullBucket(OCacheEntry cacheEntry, OWALChanges changes, OBinarySerializer<V> valueSerializer, boolean isNew) {
        super(cacheEntry, changes);
        this.valueSerializer = valueSerializer;
        if (isNew) {
            this.setByteValue(28, (byte)0);
        }
    }

    public void setValue(OSBTreeValue<V> value) throws IOException {
        this.setByteValue(28, (byte)1);
        if (value.isLink()) {
            this.setByteValue(29, (byte)0);
            this.setLongValue(30, value.getLink());
        } else {
            int valueSize = this.valueSerializer.getObjectSize(value.getValue(), new Object[0]);
            byte[] serializedValue = new byte[valueSize];
            this.valueSerializer.serializeNativeObject(value.getValue(), serializedValue, 0, new Object[0]);
            this.setByteValue(29, (byte)1);
            this.setBinaryValue(30, serializedValue);
        }
    }

    public OSBTreeValue<V> getValue() {
        boolean isLink;
        if (this.getByteValue(28) == 0) {
            return null;
        }
        boolean bl = isLink = this.getByteValue(29) == 0;
        if (isLink) {
            return new OSBTreeValue<Object>(true, this.getLongValue(30), null);
        }
        return new OSBTreeValue<V>(false, -1L, this.deserializeFromDirectMemory(this.valueSerializer, 30));
    }

    public void removeValue() {
        this.setByteValue(28, (byte)0);
    }
}

