/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.script.OCommandExecutorFunction;
import com.orientechnologies.orient.core.command.script.OCommandFunction;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionDuplicatedException;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OFunctionLibraryImpl
implements OFunctionLibrary {
    protected Map<String, OFunction> functions = new ConcurrentHashMap<String, OFunction>();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public void create() {
        this.init();
    }

    @Override
    public void load() {
        HashMap<String, OCallable<Object, Map<Object, Object>>> callbacks = new HashMap<String, OCallable<Object, Map<Object, Object>>>();
        for (Map.Entry<String, OFunction> entry : this.functions.entrySet()) {
            if (entry.getValue().getCallback() == null) continue;
            callbacks.put(entry.getKey(), entry.getValue().getCallback());
        }
        this.functions.clear();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().existsClass("OFunction")) {
            Object result = db.query(new OSQLSynchQuery("select from OFunction order by name"), new Object[0]);
            for (ODocument d : result) {
                d.reload();
                if (d.fields() == 0) continue;
                OFunction f = new OFunction(d);
                f.setCallback((OCallable)callbacks.get(f.getName()));
                this.functions.put(d.field("name").toString().toUpperCase(Locale.ENGLISH), f);
            }
        }
    }

    @Override
    public Set<String> getFunctionNames() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    @Override
    public OFunction getFunction(String iName) {
        return this.functions.get(iName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public synchronized OFunction createFunction(String iName) {
        this.init();
        OFunction f = new OFunction().setName(iName);
        try {
            f.save();
        }
        catch (ORecordDuplicatedException ex) {
            OLogManager.instance().error(this, "Exception was suppressed, original exception is", ex, new Object[0]);
            throw OException.wrapException(new OFunctionDuplicatedException("Function with name '" + iName + "' already exist"), null);
        }
        this.functions.put(iName.toUpperCase(Locale.ENGLISH), f);
        return f;
    }

    @Override
    public void close() {
        this.functions.clear();
    }

    protected void init() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db.getMetadata().getSchema().existsClass("OFunction")) {
            OClass f = db.getMetadata().getSchema().getClass("OFunction");
            OProperty prop = f.getProperty("name");
            if (prop.getAllIndexes().isEmpty()) {
                prop.createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
            }
            return;
        }
        OClass f = db.getMetadata().getSchema().createClass("OFunction");
        OProperty prop = f.createProperty("name", OType.STRING, (OType)null, true);
        prop.set(OProperty.ATTRIBUTES.NOTNULL, true);
        prop.set(OProperty.ATTRIBUTES.MANDATORY, true);
        prop.createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
        f.createProperty("code", OType.STRING, (OType)null, true);
        f.createProperty("language", OType.STRING, (OType)null, true);
        f.createProperty("idempotent", OType.BOOLEAN, (OType)null, true);
        f.createProperty("parameters", OType.EMBEDDEDLIST, OType.STRING, true);
    }

    @Override
    public synchronized void dropFunction(OFunction function) {
        String name = function.getName();
        ODocument doc = function.getDocument();
        doc.delete();
        this.functions.remove(name.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public synchronized void dropFunction(String iName) {
        OFunction function = this.getFunction(iName);
        ODocument doc = function.getDocument();
        doc.delete();
        this.functions.remove(iName.toUpperCase(Locale.ENGLISH));
    }

    static {
        try {
            try {
                OCommandManager.instance().registerExecutor(OCommandFunction.class, OCommandExecutorFunction.class);
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

