/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;

public class OFunctionTrigger
extends ODocumentHookAbstract
implements ORecordHook.Scoped {
    public static final String CLASSNAME = "OFunction";
    private static final ORecordHook.SCOPE[] SCOPES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OFunctionTrigger(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.SCOPE[] getScopes() {
        return SCOPES;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        OImmutableClass clazz = null;
        if (iRecord instanceof ODocument) {
            clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)iRecord);
        }
        if (clazz == null || !clazz.isFunction()) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        return super.onTrigger(iType, iRecord);
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.reloadLibrary();
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        this.reloadLibrary();
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        this.reloadLibrary();
    }

    protected void reloadLibrary() {
        this.database.getMetadata().getFunctionLibrary().load();
        Orient.instance().getScriptManager().close(this.database.getName());
    }

    static {
        try {
            try {
                SCOPES = new ORecordHook.SCOPE[]{ORecordHook.SCOPE.CREATE, ORecordHook.SCOPE.UPDATE, ORecordHook.SCOPE.DELETE};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

