/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import com.orientechnologies.orient.core.query.live.OLiveQueryQueueThread;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class OLiveQueryHook
extends ODocumentHookAbstract
implements ORecordHook.Scoped,
ODatabaseListener {
    private static final ORecordHook.SCOPE[] SCOPES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OLiveQueryHook(ODatabaseDocumentInternal db) {
        super(db);
        OLiveQueryHook.getOpsReference(db);
        db.registerListener(this);
    }

    @Override
    public ORecordHook.SCOPE[] getScopes() {
        return SCOPES;
    }

    public static OLiveQueryOps getOpsReference(ODatabaseInternal db) {
        return (OLiveQueryOps)db.getStorage().getResource("LiveQueryOps", new Callable<Object>(){
            private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

            @Override
            public Object call() throws Exception {
                return new OLiveQueryOps();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer subscribe(Integer token, OLiveQueryListener iListener, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to subscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return -1;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference(db);
        Object object = ops.threadLock;
        synchronized (object) {
            if (!ops.queueThread.isAlive()) {
                ops.queueThread = ops.queueThread.clone();
                ops.queueThread.start();
            }
        }
        return ops.queueThread.subscribe(token, iListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(Integer id, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to unsubscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return;
        }
        try {
            OLiveQueryOps ops = OLiveQueryHook.getOpsReference(db);
            Object object = ops.threadLock;
            synchronized (object) {
                ops.queueThread.unsubscribe(id);
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn(OLiveQueryHook.class, "Error on unsubscribing client", e, new Object[0]);
        }
    }

    @Override
    public void onCreate(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(ODatabase iDatabase) {
        if (Boolean.FALSE.equals(this.database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            ops.pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxBegin(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxRollback(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxRollback(ODatabase iDatabase) {
        if (Boolean.FALSE.equals(this.database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            ops.pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onBeforeTxCommit(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxCommit(ODatabase iDatabase) {
        List<ORecordOperation> list;
        if (Boolean.FALSE.equals(iDatabase.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            list = ops.pendingOps.remove(iDatabase);
        }
        if (list != null) {
            for (ORecordOperation item : list) {
                item.setRecord((OIdentifiable)item.getRecord().copy());
                ops.queueThread.enqueue(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(ODatabase iDatabase) {
        if (Boolean.FALSE.equals(this.database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            ops.pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onBeforeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
    }

    @Override
    public void onAfterCommand(OCommandRequestText iCommand, OCommandExecutor executor, Object result) {
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.addOp(iDocument, (byte)3);
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        this.addOp(iDocument, (byte)1);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        this.addOp(iDocument, (byte)2);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOp(ODocument iDocument, byte iType) {
        if (Boolean.FALSE.equals(this.database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        ODatabaseDocument db = this.database;
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)((Object)db));
        if (!ops.queueThread.hasListeners()) {
            return;
        }
        if (db.getTransaction() == null || !db.getTransaction().isActive()) {
            ORecordOperation op = new ORecordOperation(iDocument.copy(), iType);
            ops.queueThread.enqueue(op);
            return;
        }
        ORecordOperation result = new ORecordOperation(iDocument, iType);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            List<ORecordOperation> list = ops.pendingOps.get(db);
            if (list == null) {
                list = new ArrayList<ORecordOperation>();
                ops.pendingOps.put(db, list);
            }
            list.add(result);
        }
    }

    @Override
    public boolean onCorruptionRepairDatabase(ODatabase iDatabase, String iReason, String iWhatWillbeFixed) {
        return false;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    static {
        try {
            try {
                SCOPES = new ORecordHook.SCOPE[]{ORecordHook.SCOPE.CREATE, ORecordHook.SCOPE.UPDATE, ORecordHook.SCOPE.DELETE};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    public static class OLiveQueryOps
    implements OCloseable {
        protected Map<ODatabaseDocument, List<ORecordOperation>> pendingOps = new ConcurrentHashMap<ODatabaseDocument, List<ORecordOperation>>();
        private OLiveQueryQueueThread queueThread = new OLiveQueryQueueThread();
        private Object threadLock = new Object();
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        @Override
        public void close() {
            this.queueThread.stopExecution();
            try {
                this.queueThread.join();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.pendingOps.clear();
        }

        public OLiveQueryQueueThread getQueueThread() {
            return this.queueThread;
        }
    }
}

