/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security.kerberos;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.kerberos.OKrb5ClientLoginModuleConfig;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class OKerberosCredentialInterceptor
implements OCredentialInterceptor {
    private String principal;
    private String serviceTicket;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public String getUsername() {
        return this.principal;
    }

    @Override
    public String getPassword() {
        return this.serviceTicket;
    }

    @Override
    public void intercept(String url, String principal, String spn) throws OSecurityException {
        if (principal == null || principal.isEmpty()) {
            throw new OSecurityException("OKerberosCredentialInterceptor Principal cannot be null!");
        }
        this.principal = principal;
        String actualSPN = spn;
        if (spn == null || spn.isEmpty()) {
            if (url == null || url.isEmpty()) {
                throw new OSecurityException("OKerberosCredentialInterceptor URL and SPN cannot both be null!");
            }
            try {
                URI remoteURI;
                String host;
                String tempURL = url;
                if (tempURL.startsWith("remote:") && !tempURL.startsWith("remote://")) {
                    tempURL = tempURL.replace("remote:", "remote://");
                }
                if ((host = (remoteURI = new URI(tempURL)).getHost()) == null) {
                    throw new OSecurityException("OKerberosCredentialInterceptor Could not create SPN from URL: " + url);
                }
                actualSPN = "OrientDB/" + host;
            }
            catch (URISyntaxException ex) {
                throw OException.wrapException(new OSecurityException("OKerberosCredentialInterceptor Could not create SPN from URL: " + url), ex);
            }
        }
        String config = System.getenv("KRB5_CONFIG");
        String ckc = OGlobalConfiguration.CLIENT_KRB5_CONFIG.getValueAsString();
        if (ckc != null) {
            config = ckc;
        }
        String ccname = System.getenv("KRB5CCNAME");
        String ccn = OGlobalConfiguration.CLIENT_KRB5_CCNAME.getValueAsString();
        if (ccn != null) {
            ccname = ccn;
        }
        String ktname = System.getenv("KRB5_CLIENT_KTNAME");
        String ckn = OGlobalConfiguration.CLIENT_KRB5_KTNAME.getValueAsString();
        if (ckn != null) {
            ktname = ckn;
        }
        if (config == null) {
            throw new OSecurityException("OKerberosCredentialInterceptor KRB5 Config cannot be null!");
        }
        if (ccname == null && ktname == null) {
            throw new OSecurityException("OKerberosCredentialInterceptor KRB5 Credential Cache and KeyTab cannot both be null!");
        }
        LoginContext lc = null;
        try {
            System.setProperty("java.security.krb5.conf", config);
            OKrb5ClientLoginModuleConfig cfg = new OKrb5ClientLoginModuleConfig(principal, ccname, ktname);
            lc = new LoginContext("ignore", null, null, cfg);
            lc.login();
        }
        catch (LoginException lie) {
            OLogManager.instance().debug((Object)this, "intercept() LoginException", lie, new Object[0]);
            throw OException.wrapException(new OSecurityException("OKerberosCredentialInterceptor Client Validation Exception!"), lie);
        }
        Subject subject = lc.getSubject();
        this.serviceTicket = this.getServiceTicket(subject, principal, actualSPN);
        try {
            lc.logout();
        }
        catch (LoginException loe) {
            OLogManager.instance().debug((Object)this, "intercept() LogoutException", loe, new Object[0]);
        }
        if (this.serviceTicket == null) {
            throw new OSecurityException("OKerberosCredentialInterceptor Cannot obtain the service ticket!");
        }
    }

    private String getFirstPrincipal(Subject subject) {
        if (subject != null) {
            Object[] principals = subject.getPrincipals().toArray();
            Principal p = (Principal)principals[0];
            return p.getName();
        }
        return null;
    }

    private String getServiceTicket(Subject subject, String principal, String servicePrincipalName) {
        block7: {
            try {
                GSSManager manager = GSSManager.getInstance();
                GSSName serviceName = manager.createName(servicePrincipalName, GSSName.NT_USER_NAME);
                Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                final GSSContext context = manager.createContext(serviceName, krb5Oid, null, 0);
                if (context != null) {
                    byte[] serviceTicket;
                    boolean useNativeJgss = Boolean.getBoolean("sun.security.jgss.native");
                    if (useNativeJgss) {
                        OLogManager.instance().info((Object)this, "getServiceTicket() Using Native JGSS", new Object[0]);
                        try {
                            GSSName clientName = manager.createName(principal, GSSName.NT_USER_NAME);
                            GSSCredential cred = manager.createCredential(clientName, 0, krb5Oid, 1);
                            subject.getPrivateCredentials().add(cred);
                        }
                        catch (GSSException gssEx) {
                            OLogManager.instance().error(this, "getServiceTicket() Use Native JGSS GSSException", gssEx, new Object[0]);
                        }
                    }
                    if ((serviceTicket = Subject.doAs(subject, new PrivilegedAction<byte[]>(){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                        @Override
                        public byte[] run() {
                            try {
                                byte[] token = new byte[]{};
                                context.requestMutualAuth(false);
                                context.requestCredDeleg(false);
                                return context.initSecContext(token, 0, token.length);
                            }
                            catch (Exception inner) {
                                OLogManager.instance().debug((Object)this, "getServiceTicket() doAs() Exception", inner, new Object[0]);
                                return null;
                            }
                        }
                    })) != null) {
                        return OBase64Utils.encodeBytes(serviceTicket);
                    }
                    context.dispose();
                    break block7;
                }
                OLogManager.instance().debug((Object)this, "getServiceTicket() GSSContext is null!", new Object[0]);
            }
            catch (Exception ex) {
                OLogManager.instance().error(this, "getServiceTicket() Exception", ex, new Object[0]);
            }
        }
        return null;
    }
}

