/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import java.io.IOException;
import java.io.InputStream;

public class OMemoryInputStream
extends InputStream {
    private byte[] buffer;
    private int offset = 0;
    private int length;
    private int position;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OMemoryInputStream() {
    }

    public OMemoryInputStream(byte[] iBuffer) {
        this.setSource(iBuffer);
    }

    public OMemoryInputStream(byte[] iBuffer, int iOffset, int iLength) {
        this.setSource(iBuffer, iOffset, iLength);
    }

    public byte[] getAsByteArrayFixed(int iSize) throws IOException {
        if (this.position >= this.length) {
            return null;
        }
        byte[] portion = OArrays.copyOfRange(this.buffer, this.position, this.position + iSize);
        this.position += iSize;
        return portion;
    }

    @Override
    public int available() throws IOException {
        return this.length - this.position;
    }

    public int getAsByteArrayOffset() {
        if (this.position >= this.length) {
            return -1;
        }
        int begin = this.position;
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4 + size;
        return begin;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.length) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position >= this.length) {
            return -1;
        }
        int newLen = this.position + len >= this.length ? this.length - this.position : len;
        if (off + newLen >= b.length) {
            newLen = b.length - off;
        }
        if (newLen <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, b, off, newLen);
        this.position += newLen;
        return newLen;
    }

    public byte[] getAsByteArray(int iOffset) throws IOException {
        if (this.buffer == null || iOffset >= this.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, iOffset);
        if (size == 0) {
            return null;
        }
        return OArrays.copyOfRange(this.buffer, iOffset += 4, iOffset + size);
    }

    public byte[] getAsByteArray() throws IOException {
        if (this.position >= this.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        byte[] portion = OArrays.copyOfRange(this.buffer, this.position, this.position + size);
        this.position += size;
        return portion;
    }

    public boolean getAsBoolean() throws IOException {
        return this.buffer[this.position++] == 1;
    }

    public char getAsChar() throws IOException {
        char value = OBinaryProtocol.bytes2char(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    public byte getAsByte() throws IOException {
        return this.buffer[this.position++];
    }

    public long getAsLong() throws IOException {
        long value = OBinaryProtocol.bytes2long(this.buffer, this.position);
        this.position += 8;
        return value;
    }

    public int getAsInteger() throws IOException {
        int value = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return value;
    }

    public short getAsShort() throws IOException {
        short value = OBinaryProtocol.bytes2short(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    public byte peek() {
        return this.buffer[this.position];
    }

    public void setSource(byte[] iBuffer) {
        this.buffer = iBuffer;
        this.position = 0;
        this.offset = 0;
        this.length = iBuffer.length;
    }

    public void setSource(byte[] iBuffer, int iOffset, int iLength) {
        this.buffer = iBuffer;
        this.position = iOffset;
        this.offset = iOffset;
        this.length = iLength + iOffset;
    }

    public OMemoryInputStream jump(int iOffset) {
        this.position += iOffset;
        return this;
    }

    public byte[] copy() {
        if (this.buffer == null) {
            return null;
        }
        int size = this.position > 0 ? this.position : this.buffer.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.buffer, 0, copy, 0, size);
        return copy;
    }

    public int getVariableSize() throws IOException {
        if (this.position >= this.length) {
            return -1;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return size;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.offset;
    }
}

