/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OSimpleKeySerializer<T extends Comparable<?>>
implements OBinarySerializer<T> {
    private OType type;
    private OBinarySerializer binarySerializer;
    public static final byte ID = 15;
    public static final String NAME = "bsks";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSimpleKeySerializer() {
    }

    public OSimpleKeySerializer(OType iType) {
        this.type = iType;
        this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(iType);
    }

    @Override
    public int getObjectSize(T key, Object ... hints) {
        this.init(key, hints);
        return 1 + this.binarySerializer.getObjectSize(key, new Object[0]);
    }

    @Override
    public void serialize(T key, byte[] stream, int startPosition, Object ... hints) {
        this.init(key, hints);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serialize(key, stream, ++startPosition, new Object[0]);
    }

    @Override
    public T deserialize(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserialize(stream, ++startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSize(stream, startPosition + 1);
    }

    @Override
    public byte getId() {
        return 15;
    }

    protected void init(T key, Object[] hints) {
        if (this.binarySerializer == null) {
            OType[] types = hints != null && hints.length > 0 ? (OType[])hints : OCommonConst.EMPTY_TYPES_ARRAY;
            this.type = types.length > 0 ? types[0] : OType.getTypeByClass(key.getClass());
            this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(this.type);
        }
    }

    protected void init(byte serializerId) {
        if (this.binarySerializer == null) {
            this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
        }
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeNative(stream, startPosition + 1);
    }

    @Override
    public void serializeNativeObject(T key, byte[] stream, int startPosition, Object ... hints) {
        this.init(key, hints);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serializeNativeObject(key, stream, ++startPosition, new Object[0]);
    }

    @Override
    public T deserializeNativeObject(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeNativeObject(stream, ++startPosition));
    }

    @Override
    public boolean isFixedLength() {
        return this.binarySerializer.isFixedLength();
    }

    @Override
    public int getFixedLength() {
        return this.binarySerializer.getFixedLength() + 1;
    }

    @Override
    public T preprocess(T value, Object ... hints) {
        this.init(value, hints);
        return (T)((Comparable)this.binarySerializer.preprocess(value, new Object[0]));
    }

    @Override
    public void serializeInByteBufferObject(T object, ByteBuffer buffer, Object ... hints) {
        this.init(object, hints);
        buffer.put(this.binarySerializer.getId());
        this.binarySerializer.serializeInByteBufferObject(object, buffer, new Object[0]);
    }

    @Override
    public T deserializeFromByteBufferObject(ByteBuffer buffer) {
        byte typeId = buffer.get();
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeFromByteBufferObject(buffer));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        byte serializerId = buffer.get();
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeInByteBuffer(buffer);
    }

    @Override
    public T deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        byte typeId = walChanges.getByteValue(buffer, offset++);
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeFromByteBufferObject(buffer, walChanges, offset));
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 1 + this.binarySerializer.getObjectSizeInByteBuffer(buffer, walChanges, 1 + offset);
    }
}

