/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerRaw;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ORecordSerializerFactory {
    private static final ORecordSerializerFactory instance;
    private Map<String, ORecordSerializer> implementations = new HashMap<String, ORecordSerializer>();
    @Deprecated
    private ORecordSerializer defaultRecordFormat = new ORecordSerializerRaw();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORecordSerializerFactory() {
        this.register("ORecordDocument2csv", ORecordSerializerSchemaAware2CSV.INSTANCE);
        this.register("json", ORecordSerializerJSON.INSTANCE);
        this.register("ORecordDocumentRaw", this.defaultRecordFormat);
        this.register("ORecordSerializerBinary", ORecordSerializerBinary.INSTANCE);
        this.register("onet_ser_v0", ORecordSerializerNetwork.INSTANCE);
    }

    public void register(String iName, ORecordSerializer iInstance) {
        this.implementations.put(iName, iInstance);
    }

    public Collection<ORecordSerializer> getFormats() {
        return this.implementations.values();
    }

    public ORecordSerializer getFormat(String iFormatName) {
        if (iFormatName == null) {
            return null;
        }
        return this.implementations.get(iFormatName);
    }

    @Deprecated
    public ORecordSerializer getFormatForObject(Object iObject, String iFormatName) {
        if (iObject == null) {
            return null;
        }
        ORecordSerializer recordFormat = null;
        if (iFormatName != null) {
            recordFormat = this.implementations.get(iObject.getClass().getSimpleName() + "2" + iFormatName);
        }
        if (recordFormat == null) {
            recordFormat = this.defaultRecordFormat;
        }
        return recordFormat;
    }

    @Deprecated
    public ORecordSerializer getDefaultRecordFormat() {
        return this.defaultRecordFormat;
    }

    @Deprecated
    public void setDefaultRecordFormat(ORecordSerializer iDefaultFormat) {
        this.defaultRecordFormat = iDefaultFormat;
    }

    public static ORecordSerializerFactory instance() {
        return instance;
    }

    static {
        try {
            try {
                instance = new ORecordSerializerFactory();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

