/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV0;

public class ORecordSerializerNetwork
implements ORecordSerializer {
    public static final String NAME = "onet_ser_v0";
    public static final ORecordSerializerNetwork INSTANCE;
    private static final byte CURRENT_RECORD_VERSION = 0;
    private ODocumentSerializer[] serializerByVersion = new ODocumentSerializer[1];
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORecordSerializerNetwork() {
        this.serializerByVersion[0] = new ORecordSerializerNetworkV0();
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource == null || iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            this.checkTypeODocument(iRecord);
        }
        BytesContainer container = new BytesContainer(iSource);
        container.skip(1);
        try {
            if (iFields != null && iFields.length > 0) {
                this.serializerByVersion[iSource[0]].deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.serializerByVersion[iSource[0]].deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), OBase64Utils.encodeBytes(iSource));
            throw e;
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        this.checkTypeODocument(iSource);
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = 0;
        this.serializerByVersion[0].serialize((ODocument)iSource, container, false);
        return container.fitBytes();
    }

    @Override
    public String[] getFieldNames(ODocument reference, byte[] iSource) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            return this.serializerByVersion[iSource[0]].getFieldNames(reference, container);
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", OBase64Utils.encodeBytes(iSource));
            throw e;
        }
    }

    private void checkTypeODocument(ORecord iRecord) {
        if (!(iRecord instanceof ODocument)) {
            throw new UnsupportedOperationException("The onet_ser_v0 don't support record of type " + iRecord.getClass().getName());
        }
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = 0;
        this.serializerByVersion[0].serialize((ODocument)iSource, container, true);
        return container.fitBytes();
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return false;
    }

    static {
        try {
            try {
                INSTANCE = new ORecordSerializerNetwork();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

