/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;

public class OStreamSerializerSBTreeIndexRIDContainer
implements OStreamSerializer,
OBinarySerializer<OIndexRIDContainer> {
    public static final String NAME = "icn";
    public static final OStreamSerializerSBTreeIndexRIDContainer INSTANCE;
    public static final byte ID = 21;
    public static final int FILE_ID_OFFSET = 0;
    public static final int EMBEDDED_OFFSET = 8;
    public static final int DURABLE_OFFSET = 9;
    public static final int SBTREE_ROOTINDEX_OFFSET = 10;
    public static final int SBTREE_ROOTOFFSET_OFFSET = 18;
    public static final int EMBEDDED_SIZE_OFFSET = 10;
    public static final int EMBEDDED_VALUES_OFFSET = 14;
    public static final OLongSerializer LONG_SERIALIZER;
    public static final OBooleanSerializer BOOLEAN_SERIALIZER;
    public static final OIntegerSerializer INT_SERIALIZER;
    public static final int SBTREE_CONTAINER_SIZE = 22;
    public static final OLinkSerializer LINK_SERIALIZER;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null) {
            return null;
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getObjectSize(OIndexRIDContainer object, Object ... hints) {
        if (object.isEmbedded()) {
            return this.embeddedObjectSerializedSize(object.size());
        }
        return 22;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void serialize(OIndexRIDContainer object, byte[] stream, int startPosition, Object ... hints) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public OIndexRIDContainer deserialize(byte[] stream, int startPosition) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public byte getId() {
        return 21;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        throw new UnsupportedOperationException("Length is not fixed");
    }

    @Override
    public void serializeNativeObject(OIndexRIDContainer object, byte[] stream, int offset, Object ... hints) {
        LONG_SERIALIZER.serializeNative(object.getFileId(), stream, offset + 0, new Object[0]);
        boolean embedded = object.isEmbedded();
        boolean durable = object.isDurableNonTxMode();
        BOOLEAN_SERIALIZER.serializeNative(embedded, stream, offset + 8, new Object[0]);
        BOOLEAN_SERIALIZER.serializeNative(durable, stream, offset + 9, new Object[0]);
        if (embedded) {
            INT_SERIALIZER.serializeNative(object.size(), stream, offset + 10, new Object[0]);
            int p = offset + 14;
            for (OIdentifiable ids : object) {
                LINK_SERIALIZER.serializeNativeObject(ids, stream, p, new Object[0]);
                p += 10;
            }
        } else {
            OIndexRIDContainerSBTree underlying = (OIndexRIDContainerSBTree)object.getUnderlying();
            OBonsaiBucketPointer rootPointer = underlying.getRootPointer();
            LONG_SERIALIZER.serializeNative(rootPointer.getPageIndex(), stream, offset + 10, new Object[0]);
            INT_SERIALIZER.serializeNative(rootPointer.getPageOffset(), stream, offset + 18, new Object[0]);
        }
    }

    @Override
    public OIndexRIDContainer deserializeNativeObject(byte[] stream, int offset) {
        long fileId = LONG_SERIALIZER.deserializeNative(stream, offset + 0);
        boolean durable = BOOLEAN_SERIALIZER.deserializeNative(stream, offset + 9);
        if (BOOLEAN_SERIALIZER.deserializeNative(stream, offset + 8)) {
            int size = INT_SERIALIZER.deserializeNative(stream, offset + 10);
            HashSet<OIdentifiable> underlying = new HashSet<OIdentifiable>(Math.max((int)((float)size / 0.75f) + 1, 16));
            int p = offset + 14;
            for (int i = 0; i < size; ++i) {
                underlying.add(LINK_SERIALIZER.deserializeNativeObject(stream, p));
                p += 10;
            }
            return new OIndexRIDContainer(fileId, underlying, durable);
        }
        long pageIndex = LONG_SERIALIZER.deserializeNative(stream, offset + 10);
        int pageOffset = INT_SERIALIZER.deserializeNative(stream, offset + 18);
        OBonsaiBucketPointer rootPointer = new OBonsaiBucketPointer(pageIndex, pageOffset);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OIndexRIDContainerSBTree underlying = new OIndexRIDContainerSBTree(fileId, rootPointer, durable, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        return new OIndexRIDContainer(fileId, underlying, durable);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public OIndexRIDContainer preprocess(OIndexRIDContainer value, Object ... hints) {
        return value;
    }

    private int embeddedObjectSerializedSize(int size) {
        return 14 + size * 10;
    }

    @Override
    public void serializeInByteBufferObject(OIndexRIDContainer object, ByteBuffer buffer, Object ... hints) {
        buffer.putLong(object.getFileId());
        boolean embedded = object.isEmbedded();
        boolean durable = object.isDurableNonTxMode();
        buffer.put((byte)(embedded ? 1 : 0));
        buffer.put((byte)(durable ? 1 : 0));
        if (embedded) {
            buffer.putInt(object.size());
            for (OIdentifiable ids : object) {
                LINK_SERIALIZER.serializeInByteBufferObject(ids, buffer, new Object[0]);
            }
        } else {
            OIndexRIDContainerSBTree underlying = (OIndexRIDContainerSBTree)object.getUnderlying();
            OBonsaiBucketPointer rootPointer = underlying.getRootPointer();
            buffer.putLong(rootPointer.getPageIndex());
            buffer.putInt(rootPointer.getPageOffset());
        }
    }

    @Override
    public OIndexRIDContainer deserializeFromByteBufferObject(ByteBuffer buffer) {
        boolean durable;
        long fileId = buffer.getLong();
        boolean embedded = buffer.get() > 0;
        boolean bl = durable = buffer.get() > 0;
        if (embedded) {
            int size = buffer.getInt();
            HashSet<OIdentifiable> underlying = new HashSet<OIdentifiable>(Math.max((int)((float)size / 0.75f) + 1, 16));
            for (int i = 0; i < size; ++i) {
                underlying.add(LINK_SERIALIZER.deserializeFromByteBufferObject(buffer));
            }
            return new OIndexRIDContainer(fileId, underlying, durable);
        }
        long pageIndex = buffer.getLong();
        int pageOffset = buffer.getInt();
        OBonsaiBucketPointer rootPointer = new OBonsaiBucketPointer(pageIndex, pageOffset);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OIndexRIDContainerSBTree underlying = new OIndexRIDContainerSBTree(fileId, rootPointer, durable, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        return new OIndexRIDContainer(fileId, underlying, durable);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        int offset = buffer.position();
        buffer.position();
        if (buffer.get(offset + 8) > 0) {
            return this.embeddedObjectSerializedSize(buffer.getInt(offset + 10));
        }
        return 22;
    }

    @Override
    public OIndexRIDContainer deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        boolean durable;
        long fileId = walChanges.getLongValue(buffer, offset + 0);
        boolean bl = durable = walChanges.getByteValue(buffer, offset + 9) > 0;
        if (walChanges.getByteValue(buffer, offset + 8) > 0) {
            int size = walChanges.getIntValue(buffer, offset + 10);
            HashSet<OIdentifiable> underlying = new HashSet<OIdentifiable>(Math.max((int)((float)size / 0.75f) + 1, 16));
            int p = offset + 14;
            for (int i = 0; i < size; ++i) {
                underlying.add(LINK_SERIALIZER.deserializeFromByteBufferObject(buffer, walChanges, p));
                p += 10;
            }
            return new OIndexRIDContainer(fileId, underlying, durable);
        }
        long pageIndex = walChanges.getLongValue(buffer, offset + 10);
        int pageOffset = walChanges.getIntValue(buffer, offset + 18);
        OBonsaiBucketPointer rootPointer = new OBonsaiBucketPointer(pageIndex, pageOffset);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OIndexRIDContainerSBTree underlying = new OIndexRIDContainerSBTree(fileId, rootPointer, durable, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        return new OIndexRIDContainer(fileId, underlying, durable);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        if (walChanges.getByteValue(buffer, offset + 8) > 0) {
            return this.embeddedObjectSerializedSize(walChanges.getIntValue(buffer, offset + 10));
        }
        return 22;
    }

    static {
        try {
            try {
                INSTANCE = new OStreamSerializerSBTreeIndexRIDContainer();
                LONG_SERIALIZER = OLongSerializer.INSTANCE;
                BOOLEAN_SERIALIZER = OBooleanSerializer.INSTANCE;
                INT_SERIALIZER = OIntegerSerializer.INSTANCE;
                LINK_SERIALIZER = OLinkSerializer.INSTANCE;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

