/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;
import java.io.UnsupportedEncodingException;

public class OStringSerializerEmbedded
implements OStringSerializer {
    public static final OStringSerializerEmbedded INSTANCE;
    public static final String NAME = "em";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        ODocument instance = new ODocument();
        try {
            ORecordSerializerSchemaAware2CSV.INSTANCE.fromStream(iStream.getBytes("UTF-8"), instance, null);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error decoding string"), e);
        }
        String className = (String)instance.field("__orientdb_serilized_class__ ");
        if (className == null) {
            return instance;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            OLogManager.instance().debug((Object)this, "Class name provided in embedded document " + className + " does not exist.", e, new Object[0]);
        }
        if (clazz == null) {
            return instance;
        }
        if (ODocumentSerializable.class.isAssignableFrom(clazz)) {
            try {
                ODocumentSerializable documentSerializable = (ODocumentSerializable)clazz.newInstance();
                ODocument docClone = new ODocument();
                instance.copyTo(docClone);
                docClone.removeField("__orientdb_serilized_class__ ");
                documentSerializable.fromDocument(docClone);
                return documentSerializable;
            }
            catch (InstantiationException e) {
                throw OException.wrapException(new OSerializationException("Cannot serialize the object"), e);
            }
            catch (IllegalAccessException e) {
                throw OException.wrapException(new OSerializationException("Cannot serialize the object"), e);
            }
        }
        return instance;
    }

    @Override
    public StringBuilder toStream(StringBuilder iOutput, Object iValue) {
        if (iValue != null) {
            if (iValue instanceof ODocumentSerializable) {
                iValue = ((ODocumentSerializable)iValue).toDocument();
            }
            if (!(iValue instanceof OSerializableStream)) {
                throw new OSerializationException("Cannot serialize the object since it's not implements the OSerializableStream interface");
            }
            OSerializableStream stream = (OSerializableStream)iValue;
            iOutput.append(iValue.getClass().getName());
            iOutput.append("|");
            try {
                iOutput.append(new String(stream.toStream(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw OException.wrapException(new OSerializationException("Error serializing embedded object"), e);
            }
        }
        return iOutput;
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            try {
                INSTANCE = new OStringSerializerEmbedded();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

