/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLCreateFunction
extends OCommandExecutorSQLAbstract {
    public static final String NAME = "CREATE FUNCTION";
    private String name;
    private String code;
    private String language;
    private boolean idempotent = false;
    private List<String> parameters = null;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateFunction parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword("CREATE");
            this.parserRequiredKeyword("FUNCTION");
            this.name = this.parserNextWord(false);
            this.code = OIOUtils.getStringContent(this.parserNextWord(false));
            String temp = this.parseOptionalWord(true, new String[0]);
            while (temp != null) {
                if (temp.equals("IDEMPOTENT")) {
                    this.parserNextWord(false);
                    this.idempotent = Boolean.parseBoolean(this.parserGetLastWord());
                } else if (temp.equals("LANGUAGE")) {
                    this.parserNextWord(false);
                    this.language = this.parserGetLastWord();
                } else if (temp.equals("PARAMETERS")) {
                    this.parserNextWord(false);
                    this.parameters = new ArrayList<String>();
                    OStringSerializerHelper.getCollection(this.parserGetLastWord(), 0, this.parameters);
                    if (this.parameters.size() == 0) {
                        throw new OCommandExecutionException("Syntax Error. Missing function parameter(s): " + this.getSyntax());
                    }
                }
                temp = this.parserOptionalWord(true);
                if (!this.parserIsEnded()) continue;
                break;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.name.isEmpty()) {
            throw new OCommandExecutionException("Syntax Error. You must specify a function name: " + this.getSyntax());
        }
        if (this.code == null || this.code.isEmpty()) {
            throw new OCommandExecutionException("Syntax Error. You must specify the function code: " + this.getSyntax());
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateFunction.getDatabase();
        OFunction f = database.getMetadata().getFunctionLibrary().createFunction(this.name);
        f.setCode(this.code);
        f.setIdempotent(this.idempotent);
        if (this.parameters != null) {
            f.setParameters(this.parameters);
        }
        if (this.language != null) {
            f.setLanguage(this.language);
        }
        f.save();
        return f.getId();
    }

    @Override
    public String getSyntax() {
        return "CREATE FUNCTION <name> <code> [PARAMETERS [<comma-separated list of parameters' name>]] [IDEMPOTENT true|false] [LANGUAGE <language>]";
    }
}

