/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Iterator;
import java.util.Map;

public class OCommandExecutorSQLOptimizeDatabase
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_OPTIMIZE = "OPTIMIZE";
    public static final String KEYWORD_DATABASE = "DATABASE";
    public static final String KEYWORD_EDGE = "-LWEDGES";
    public static final String KEYWORD_NOVERBOSE = "-NOVERBOSE";
    private boolean optimizeEdges = false;
    private boolean verbose = true;
    private int batch = 1000;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLOptimizeDatabase parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_OPTIMIZE)) {
                throw new OCommandSQLParsingException("Keyword OPTIMIZE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_DATABASE)) {
                throw new OCommandSQLParsingException("Keyword DATABASE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            while (!this.parserIsEnded() && word.length() > 0) {
                oldPos = pos;
                pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
                if (word.toString().equals(KEYWORD_EDGE)) {
                    this.optimizeEdges = true;
                    continue;
                }
                if (!word.toString().equals(KEYWORD_NOVERBOSE)) continue;
                this.verbose = false;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        StringBuilder result = new StringBuilder();
        if (this.optimizeEdges) {
            result.append(this.optimizeEdges());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String optimizeEdges() {
        ODatabaseDocumentInternal db = OCommandExecutorSQLOptimizeDatabase.getDatabase();
        db.declareIntent(new OIntentMassiveInsert());
        try {
            long transformed = 0L;
            if (db.getTransaction().isActive()) {
                db.commit();
            }
            db.begin();
            try {
                long totalEdges = db.countClass("E");
                long browsedEdges = 0L;
                long lastLapBrowsed = 0L;
                long lastLapTime = System.currentTimeMillis();
                for (ODocument doc : db.browseClass("E")) {
                    if (Thread.currentThread().isInterrupted()) break;
                    ++browsedEdges;
                    if (doc == null || doc.fields() != 2) continue;
                    ORID edgeIdentity = doc.getIdentity();
                    ODocument outV = (ODocument)doc.field("out");
                    ODocument inV = (ODocument)doc.field("in");
                    Object outField = outV.field("out_" + doc.getClassName());
                    if (outField instanceof ORidBag) {
                        Iterator<OIdentifiable> it = ((ORidBag)outField).iterator();
                        while (it.hasNext()) {
                            OIdentifiable v = it.next();
                            if (!edgeIdentity.equals(v)) continue;
                            it.remove();
                            ((ORidBag)outField).add(inV.getIdentity());
                            break;
                        }
                    }
                    outV.save();
                    Object inField = inV.field("in_" + doc.getClassName());
                    if (outField instanceof ORidBag) {
                        Iterator<OIdentifiable> it = ((ORidBag)inField).iterator();
                        while (it.hasNext()) {
                            OIdentifiable v = it.next();
                            if (!edgeIdentity.equals(v)) continue;
                            it.remove();
                            ((ORidBag)inField).add(outV.getIdentity());
                            break;
                        }
                    }
                    inV.save();
                    doc.delete();
                    if (++transformed % (long)this.batch == 0L) {
                        db.commit();
                        db.begin();
                    }
                    long now = System.currentTimeMillis();
                    if (!this.verbose || now - lastLapTime <= 2000L) continue;
                    long elapsed = now - lastLapTime;
                    OLogManager.instance().info((Object)this, "Browsed %,d of %,d edges, transformed %,d so far (%,d edges/sec)", browsedEdges, totalEdges, transformed, (browsedEdges - lastLapBrowsed) * 1000L / elapsed);
                    lastLapTime = System.currentTimeMillis();
                    lastLapBrowsed = browsedEdges;
                }
                db.commit();
            }
            finally {
                if (db.getTransaction().isActive()) {
                    db.rollback();
                }
            }
            String string = "Transformed " + transformed + " regular edges in lightweight edges";
            return string;
        }
        finally {
            db.declareIntent(null);
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public String getSyntax() {
        return "OPTIMIZE DATABASE [-lwedges]";
    }
}

