/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLRevoke
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_REVOKE = "REVOKE";
    private static final String KEYWORD_FROM = "FROM";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLRevoke parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLRevoke.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.privilege = 0;
            this.resource = null;
            this.role = null;
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_REVOKE)) {
                throw new OCommandSQLParsingException("Keyword REVOKE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if ((pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Invalid privilege", this.parserText, oldPos);
            }
            this.parsePrivilege(word, oldPos);
            pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true);
            if (pos == -1 || !word.toString().equals("ON")) {
                throw new OCommandSQLParsingException("Keyword ON not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if ((pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserText, pos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Invalid resource", this.parserText, oldPos);
            }
            this.resource = word.toString();
            if ((pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_FROM)) {
                throw new OCommandSQLParsingException("Keyword FROM not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if ((pos = OCommandExecutorSQLRevoke.nextWord(this.parserText, this.parserText, pos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Invalid role", this.parserText, oldPos);
            }
            String roleName = word.toString();
            this.role = database.getMetadata().getSecurity().getRole(roleName);
            if (this.role == null) {
                throw new OCommandSQLParsingException("Invalid role: " + roleName);
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.role == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        this.role.revoke(this.resource, this.privilege);
        this.role.save();
        return this.role;
    }

    @Override
    public String getSyntax() {
        return "REVOKE <permission> ON <resource> FROM <role>";
    }
}

