/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLTraverse
extends OCommandExecutorSQLResultsetAbstract {
    public static final String KEYWORD_WHILE = "WHILE";
    public static final String KEYWORD_TRAVERSE = "TRAVERSE";
    public static final String KEYWORD_STRATEGY = "STRATEGY";
    public static final String KEYWORD_MAXDEPTH = "MAXDEPTH";
    private OTraverse traverse = new OTraverse();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandExecutorSQLTraverse parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            super.parse(iRequest);
            int pos = this.parseFields();
            if (pos == -1) {
                throw new OCommandSQLParsingException("Traverse must have the field list. Use " + this.getSyntax());
            }
            this.parserSetCurrentPosition(pos);
            int endPosition = this.parserText.length();
            this.parsedTarget = OSQLEngine.getInstance().parseTarget(this.parserText.substring(pos, endPosition), this.getContext());
            if (this.parsedTarget.parserIsEnded()) {
                this.parserSetCurrentPosition(endPosition);
            } else {
                this.parserMoveCurrentPosition(this.parsedTarget.parserGetCurrentPosition());
            }
            if (!this.parserIsEnded()) {
                this.parserNextWord(true);
                if (this.parserGetLastWord().equalsIgnoreCase("WHERE")) {
                    this.warnDeprecatedWhere();
                }
                if (this.parserGetLastWord().equalsIgnoreCase("WHERE") || this.parserGetLastWord().equalsIgnoreCase(KEYWORD_WHILE)) {
                    this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), KEYWORD_WHILE);
                    this.traverse.predicate(this.compiledFilter);
                    this.optimize();
                    this.parserSetCurrentPosition(this.compiledFilter.parserIsEnded() ? endPosition : this.compiledFilter.parserGetCurrentPosition() + this.parserGetCurrentPosition());
                } else {
                    this.parserGoBack();
                }
            }
            this.parserSkipWhiteSpaces();
            while (!this.parserIsEnded()) {
                if (!this.parserOptionalKeyword("LIMIT", "SKIP", "OFFSET", "TIMEOUT", KEYWORD_MAXDEPTH, KEYWORD_STRATEGY)) continue;
                String w = this.parserGetLastWord();
                if (w.equals("LIMIT")) {
                    this.parseLimit(w);
                    continue;
                }
                if (w.equals("SKIP") || w.equals("OFFSET")) {
                    this.parseSkip(w);
                    continue;
                }
                if (w.equals("TIMEOUT")) {
                    this.parseTimeout(w);
                    continue;
                }
                if (w.equals(KEYWORD_MAXDEPTH)) {
                    this.parseMaxDepth(w);
                    continue;
                }
                if (!w.equals(KEYWORD_STRATEGY)) continue;
                this.parseStrategy(w);
            }
            if (this.limit == 0 || this.limit < -1) {
                throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
            }
            this.traverse.limit(this.limit);
            this.traverse.getContext().setParent(iRequest.getContext());
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    protected boolean parseMaxDepth(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_MAXDEPTH)) {
            return false;
        }
        String word = this.parserNextWord(true);
        try {
            this.traverse.setMaxDepth(Integer.parseInt(word));
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error during setting of max depth", e, new Object[0]);
            this.throwParsingException("Invalid MAXDEPTH value set to '" + word + "' but it should be a valid long. Example: " + KEYWORD_MAXDEPTH + " 3000");
        }
        if (this.traverse.getMaxDepth() < 0) {
            this.throwParsingException("Invalid MAXDEPTH: value set minor than ZERO. Example: MAXDEPTH 3");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.context.beginExecution(this.timeoutMs, this.timeoutStrategy);
        if (!this.assignTarget(iArgs)) {
            throw new OQueryParsingException("No source found in query: specify class, cluster(s) or single record(s)");
        }
        try {
            OIdentifiable r;
            Object result = this.traverse.execute();
            Object object = result.iterator();
            while (object.hasNext() && this.handleResult(r = (OIdentifiable)object.next(), this.context)) {
            }
            object = this.getResult();
            return object;
        }
        finally {
            this.request.getResultListener().end();
        }
    }

    @Override
    public OCommandContext getContext() {
        return this.traverse.getContext();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<OIdentifiable> iterator(Map<Object, Object> iArgs) {
        this.assignTarget(iArgs);
        return this.traverse;
    }

    @Override
    public String getSyntax() {
        return "TRAVERSE <field>* FROM <target> [MAXDEPTH <max-depth>] [WHILE <condition>] [STRATEGY <strategy>]";
    }

    protected void warnDeprecatedWhere() {
        OLogManager.instance().warn((Object)this, "Keyword WHERE in traverse has been replaced by WHILE. Please change your query to support WHILE instead of WHERE because now it's only deprecated, but in future it will be removed the back-ward compatibility.", new Object[0]);
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (super.assignTarget(iArgs)) {
            this.traverse.target(this.target);
            return true;
        }
        return false;
    }

    protected int parseFields() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OCommandExecutorSQLTraverse.nextWord(this.parserText, this.parserTextUpperCase, currentPos, word, true);
        if (!word.toString().equals(KEYWORD_TRAVERSE)) {
            return -1;
        }
        int fromPosition = this.parserTextUpperCase.indexOf(" FROM ", currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.parserText, currentPos);
        }
        HashSet<Object> fields = new HashSet<Object>();
        String fieldString = this.parserText.substring(currentPos, fromPosition).trim();
        if (fieldString.length() > 0) {
            List<String> items = OStringSerializerHelper.smartSplit(fieldString, ',', new char[0]);
            for (String field : items) {
                String fieldName = field.trim();
                if (fieldName.contains("(")) {
                    fields.add(OSQLHelper.parseValue(null, fieldName, this.context));
                    continue;
                }
                fields.add(fieldName);
            }
        } else {
            throw new OQueryParsingException("Missed field list to cross in TRAVERSE. Use " + this.getSyntax(), this.parserText, currentPos);
        }
        currentPos = fromPosition + "FROM".length() + 1;
        this.traverse.fields(fields);
        return currentPos;
    }

    protected boolean parseStrategy(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_STRATEGY)) {
            return false;
        }
        String strategyWord = this.parserNextWord(true);
        try {
            this.traverse.setStrategy(OTraverse.STRATEGY.valueOf(strategyWord.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException e) {
            OLogManager.instance().debug((Object)this, "Error during setting of traverse strategy", e, new Object[0]);
            this.throwParsingException("Invalid STRATEGY. Use one between " + Arrays.toString((Object[])OTraverse.STRATEGY.values()));
        }
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }
}

