/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.object.OLazyObjectListInterface;
import com.orientechnologies.orient.core.db.object.OLazyObjectMapInterface;
import com.orientechnologies.orient.core.db.object.OLazyObjectSetInterface;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OFindReferenceHelper {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static List<ODocument> findReferences(Set<ORID> iRecordIds, String classList) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        HashMap<ORID, Set<ORID>> map = new HashMap<ORID, Set<ORID>>();
        for (ORID rid : iRecordIds) {
            map.put(rid, new HashSet());
        }
        if (classList == null || classList.isEmpty()) {
            for (String clusterName : db.getClusterNames()) {
                OFindReferenceHelper.browseCluster(db, iRecordIds, map, clusterName);
            }
        } else {
            List<String> classes = OStringSerializerHelper.smartSplit(classList, ',', new char[0]);
            for (String string : classes) {
                if (string.startsWith("CLUSTER:")) {
                    OFindReferenceHelper.browseCluster(db, iRecordIds, map, string.substring(string.indexOf("CLUSTER:") + "CLUSTER:".length()));
                    continue;
                }
                OFindReferenceHelper.browseClass(db, iRecordIds, map, string);
            }
        }
        ArrayList<ODocument> result = new ArrayList<ODocument>();
        for (Map.Entry entry : map.entrySet()) {
            ODocument doc = new ODocument();
            result.add(doc);
            doc.field("rid", entry.getKey());
            doc.field("referredBy", entry.getValue());
        }
        return result;
    }

    private static void browseCluster(ODatabaseDocument iDatabase, Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, String iClusterName) {
        for (ORecord record : iDatabase.browseCluster(iClusterName)) {
            if (!(record instanceof ODocument)) continue;
            try {
                for (String fieldName : ((ODocument)record).fieldNames()) {
                    Object value = ((ODocument)record).field(fieldName);
                    OFindReferenceHelper.checkObject(iSourceRIDs, map, value, (ODocument)record);
                }
            }
            catch (Exception e) {
                OLogManager.instance().debug(null, "Error reading record " + record.getIdentity(), e, new Object[0]);
            }
        }
    }

    private static void browseClass(ODatabaseDocument db, Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, String iClassName) {
        OClass clazz = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().getClass(iClassName);
        if (clazz == null) {
            throw new OCommandExecutionException("Class '" + iClassName + "' was not found");
        }
        for (int i : clazz.getClusterIds()) {
            OFindReferenceHelper.browseCluster(db, iSourceRIDs, map, db.getClusterNameById(i));
        }
    }

    private static void checkObject(Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, Object value, ORecord iRootObject) {
        if (value instanceof OIdentifiable) {
            OFindReferenceHelper.checkRecord(iSourceRIDs, map, (OIdentifiable)value, iRootObject);
        } else if (value instanceof Collection) {
            OFindReferenceHelper.checkCollection(iSourceRIDs, map, (Collection)value, iRootObject);
        } else if (value instanceof Map) {
            OFindReferenceHelper.checkMap(iSourceRIDs, map, (Map)value, iRootObject);
        }
    }

    private static void checkCollection(Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, Collection<?> values, ORecord iRootObject) {
        Iterator<Object> it;
        if (values instanceof OLazyObjectListInterface) {
            ((OLazyObjectListInterface)values).setConvertToRecord(false);
            it = ((OLazyObjectListInterface)values).listIterator();
        } else if (values instanceof OLazyObjectSetInterface) {
            ((OLazyObjectSetInterface)values).setConvertToRecord(false);
            it = ((OLazyObjectSetInterface)values).iterator();
        } else {
            it = values instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)values)).rawIterator() : values.iterator();
        }
        while (it.hasNext()) {
            OFindReferenceHelper.checkObject(iSourceRIDs, map, it.next(), iRootObject);
        }
    }

    private static void checkMap(Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, Map<?, ?> values, ORecord iRootObject) {
        Iterator<OIdentifiable> it;
        if (values instanceof OLazyObjectMapInterface) {
            ((OLazyObjectMapInterface)values).setConvertToRecord(false);
            it = ((OLazyObjectMapInterface)values).values().iterator();
        } else {
            it = values instanceof ORecordLazyMap ? ((ORecordLazyMap)values).rawIterator() : values.values().iterator();
        }
        while (it.hasNext()) {
            OFindReferenceHelper.checkObject(iSourceRIDs, map, it.next(), iRootObject);
        }
    }

    private static void checkRecord(Set<ORID> iSourceRIDs, Map<ORID, Set<ORID>> map, OIdentifiable value, ORecord iRootObject) {
        if (iSourceRIDs.contains(value.getIdentity())) {
            map.get(value.getIdentity()).add(iRootObject.getIdentity());
        } else if (!value.getIdentity().isValid() && value.getRecord() instanceof ODocument) {
            ODocument doc = (ODocument)value.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue = doc.field(fieldName);
                OFindReferenceHelper.checkObject(iSourceRIDs, map, fieldValue, iRootObject);
            }
        }
    }
}

