/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class OSQLFunctionDecimal
extends OSQLFunctionMathAbstract {
    public static final String NAME = "decimal";
    private Object result;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionDecimal() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object inputValue = iParams[0];
        if (inputValue == null) {
            this.result = null;
        }
        if (inputValue instanceof BigDecimal) {
            this.result = inputValue;
        } else if (inputValue instanceof BigInteger) {
            this.result = new BigDecimal((BigInteger)inputValue);
        } else if (inputValue instanceof Integer) {
            this.result = new BigDecimal((Integer)inputValue);
        } else if (inputValue instanceof Long) {
            this.result = new BigDecimal((Long)inputValue);
        } else if (inputValue instanceof Number) {
            this.result = new BigDecimal(((Number)inputValue).doubleValue());
        }
        try {
            if (inputValue instanceof String) {
                this.result = new BigDecimal((String)inputValue);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error in SQL function 'decimal'", e, new Object[0]);
            this.result = null;
        }
        return this.getResult();
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "decimal(<val>)";
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

