/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.Collection;
import java.util.List;

public class OSQLFunctionMax
extends OSQLFunctionMathAbstract {
    public static final String NAME = "max";
    private Object context;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionMax() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object max = null;
        for (Object item : iParams) {
            if (item instanceof Collection) {
                for (Object subitem : (Collection)item) {
                    if (max != null && (subitem == null || ((Comparable)subitem).compareTo(max) <= 0)) continue;
                    max = subitem;
                }
                continue;
            }
            if (item instanceof Number && max instanceof Number) {
                Number[] converted = OType.castComparableNumber((Number)item, (Number)max);
                item = converted[0];
                max = converted[1];
            }
            if (max != null && (item == null || ((Comparable)item).compareTo(max) <= 0)) continue;
            max = item;
        }
        if (this.aggregateResults() && max != null) {
            if (this.context == null) {
                this.context = (Comparable)max;
            } else {
                if (this.context instanceof Number && max instanceof Number) {
                    Number[] casted = OType.castComparableNumber((Number)this.context, (Number)max);
                    this.context = casted[0];
                    max = casted[1];
                }
                if (((Comparable)this.context).compareTo((Comparable)max) < 0) {
                    this.context = (Comparable)max;
                }
            }
            return null;
        }
        return max;
    }

    @Override
    public boolean aggregateResults() {
        return this.configuredParameters.length == 1 && !this.configuredParameters[0].toString().contains("$current");
    }

    @Override
    public String getSyntax() {
        return "max(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        return this.context;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Comparable context = null;
        for (Object iParameter : resultsToMerge) {
            Comparable value = (Comparable)iParameter;
            if (context == null) {
                context = value;
                continue;
            }
            if (context.compareTo(value) >= 0) continue;
            context = value;
        }
        return context;
    }
}

