/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.Collection;
import java.util.List;

public class OSQLFunctionMin
extends OSQLFunctionMathAbstract {
    public static final String NAME = "min";
    private Object context;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionMin() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object min = null;
        for (Object item : iParams) {
            if (item instanceof Collection) {
                for (Object subitem : (Collection)item) {
                    if (min != null && (subitem == null || ((Comparable)subitem).compareTo(min) >= 0)) continue;
                    min = subitem;
                }
                continue;
            }
            if (item instanceof Number && min instanceof Number) {
                Number[] converted = OType.castComparableNumber((Number)item, (Number)min);
                item = converted[0];
                min = converted[1];
            }
            if (min != null && (item == null || ((Comparable)item).compareTo(min) >= 0)) continue;
            min = item;
        }
        if (this.aggregateResults() && min != null) {
            if (this.context == null) {
                this.context = (Comparable)min;
            } else {
                if (this.context instanceof Number && min instanceof Number) {
                    Number[] casted = OType.castComparableNumber((Number)this.context, (Number)min);
                    this.context = casted[0];
                    min = casted[1];
                }
                if (((Comparable)this.context).compareTo((Comparable)min) > 0) {
                    this.context = (Comparable)min;
                }
            }
            return null;
        }
        return min;
    }

    @Override
    public boolean aggregateResults() {
        return this.configuredParameters.length == 1 && !this.configuredParameters[0].toString().contains("$current");
    }

    @Override
    public String getSyntax() {
        return "min(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        return this.context;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Comparable context = null;
        for (Object iParameter : resultsToMerge) {
            Comparable value = (Comparable)iParameter;
            if (context == null) {
                context = value;
                continue;
            }
            if (context.compareTo(value) <= 0) continue;
            context = value;
        }
        return context;
    }
}

