/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;

public class OSQLFunctionIf
extends OSQLFunctionAbstract {
    public static final String NAME = "if";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLFunctionIf() {
        super(NAME, 2, 3);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        try {
            boolean result;
            Object condition = iParams[0];
            if (condition instanceof Boolean) {
                result = (Boolean)condition;
            } else if (condition instanceof String) {
                result = Boolean.parseBoolean(condition.toString());
            } else if (condition instanceof Number) {
                result = ((Number)condition).intValue() > 0;
            } else {
                return null;
            }
            return result ? iParams[1] : iParams[2];
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Error during execution a function '%s'", e, NAME);
            return null;
        }
    }

    @Override
    public String getSyntax() {
        return "if(<field|value|expression>, <return_value_if_true> [,<return_value_if_false>])";
    }
}

