/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;
import java.util.Map;

public class OSQLMethodExclude
extends OAbstractSQLMethod {
    public static final String NAME = "exclude";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLMethodExclude() {
        super(NAME, 1, -1);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: exclude([<field-name>][,]*)";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis != null) {
            if (iThis instanceof ORecordId) {
                iThis = ((ORecordId)iThis).getRecord();
            }
            if (iThis instanceof ODocument) {
                return this.copy((ODocument)iThis, iParams);
            }
            if (iThis instanceof Map) {
                return this.copy((Map)iThis, iParams);
            }
            if (OMultiValue.isMultiValue(iThis)) {
                ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize(iThis));
                for (Object o : OMultiValue.getMultiValueIterable(iThis, false)) {
                    if (!(o instanceof OIdentifiable)) continue;
                    result.add(this.copy((ODocument)((OIdentifiable)o).getRecord(), iParams));
                }
                return result;
            }
        }
        return null;
    }

    private Object copy(ODocument document, Object[] iFieldNames) {
        ODocument doc = document.copy();
        for (Object iFieldName : iFieldNames) {
            if (iFieldName == null) continue;
            String fieldName = iFieldName.toString();
            if (fieldName.endsWith("*")) {
                String fieldPart = fieldName.substring(0, fieldName.length() - 1);
                ArrayList<String> toExclude = new ArrayList<String>();
                for (String f : doc.fieldNames()) {
                    if (!f.startsWith(fieldPart)) continue;
                    toExclude.add(f);
                }
                for (String f : toExclude) {
                    doc.removeField(f);
                }
                continue;
            }
            doc.removeField(fieldName);
        }
        doc.deserializeFields(new String[0]);
        return doc;
    }

    private Object copy(Map map, Object[] iFieldNames) {
        ODocument doc = new ODocument().fields(map);
        for (Object iFieldName : iFieldNames) {
            if (iFieldName == null) continue;
            String fieldName = iFieldName.toString();
            if (fieldName.endsWith("*")) {
                String fieldPart = fieldName.substring(0, fieldName.length() - 1);
                ArrayList<String> toExclude = new ArrayList<String>();
                for (String f : doc.fieldNames()) {
                    if (!f.startsWith(fieldPart)) continue;
                    toExclude.add(f);
                }
                for (String f : toExclude) {
                    doc.removeField(f);
                }
                continue;
            }
            doc.removeField(fieldName);
        }
        return doc;
    }
}

